/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.nts.variant;

import com.google.common.base.Joiner;
import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.HGVSVariant;
import de.charite.compbio.jannovar.hgvs.SequenceType;

public abstract class NucleotideVariant
extends HGVSVariant {
    public static final int NO_TRANSCRIPT_VERSION = -1;
    protected final SequenceType seqType;
    protected final String refID;
    protected final String proteinID;
    protected final int transcriptVersion;

    public NucleotideVariant(SequenceType seqType, String refID) {
        this.seqType = seqType;
        this.refID = refID;
        this.proteinID = null;
        this.transcriptVersion = -1;
    }

    public NucleotideVariant(SequenceType seqType, String refID, String proteinID, int transcriptVersion) {
        this.seqType = seqType;
        this.refID = refID;
        this.proteinID = proteinID;
        this.transcriptVersion = transcriptVersion;
    }

    public SequenceType getSeqType() {
        return this.seqType;
    }

    public String getRefID() {
        return this.refID;
    }

    public int getTranscriptVersion() {
        return this.transcriptVersion;
    }

    public String getProteinID() {
        return this.proteinID;
    }

    public String getRefIDWithVersion() {
        if (this.transcriptVersion == -1) {
            return this.getRefID();
        }
        return Joiner.on((String)"").join((Object)this.getRefID(), (Object)".", new Object[]{this.transcriptVersion});
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        return this.toHGVSString();
    }

    public String getSequenceNamePrefix() {
        if (this.proteinID == null) {
            return this.getRefIDWithVersion();
        }
        return Joiner.on((String)"").join((Object)this.getRefIDWithVersion(), (Object)"(", new Object[]{this.proteinID, ")"});
    }

    public String toString() {
        return "NucleotideVariant [seqType=" + (Object)((Object)this.seqType) + ", refID=" + this.refID + ", proteinID=" + this.proteinID + ", transcriptVersion=" + this.transcriptVersion + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.proteinID == null ? 0 : this.proteinID.hashCode());
        result = 31 * result + (this.refID == null ? 0 : this.refID.hashCode());
        result = 31 * result + (this.seqType == null ? 0 : this.seqType.hashCode());
        result = 31 * result + this.transcriptVersion;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NucleotideVariant other = (NucleotideVariant)obj;
        if (this.proteinID == null ? other.proteinID != null : !this.proteinID.equals(other.proteinID)) {
            return false;
        }
        if (this.refID == null ? other.refID != null : !this.refID.equals(other.refID)) {
            return false;
        }
        if (this.seqType != other.seqType) {
            return false;
        }
        return this.transcriptVersion == other.transcriptVersion;
    }
}

