/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.parser;

import de.charite.compbio.jannovar.hgvs.HGVSVariant;
import de.charite.compbio.jannovar.hgvs.parser.Antlr4HGVSParser;
import de.charite.compbio.jannovar.hgvs.parser.Antlr4HGVSParserListenerImpl;
import de.charite.compbio.jannovar.hgvs.parser.HGVSErrorStrategy;
import de.charite.compbio.jannovar.hgvs.parser.HGVSLexer;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HGVSParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(HGVSParser.class);
    private boolean debug = false;

    public HGVSParser() {
    }

    public HGVSParser(boolean debug) {
        this.debug = debug;
    }

    public HGVSVariant parseHGVSString(String inputString) {
        LOGGER.trace("Parsing input string " + inputString);
        Antlr4HGVSParser parser = this.getParser(inputString);
        parser.setErrorHandler((ANTLRErrorStrategy)new HGVSErrorStrategy());
        Antlr4HGVSParserListenerImpl listener = new Antlr4HGVSParserListenerImpl();
        parser.addParseListener(listener);
        parser.setTrace(this.debug);
        Antlr4HGVSParser.Hgvs_variantContext tree = parser.hgvs_variant();
        if (this.debug) {
            System.err.println(tree.toStringTree(parser));
        }
        return listener.getHGVSVariant();
    }

    private Antlr4HGVSParser getParser(String inputString) {
        Object l;
        CodePointCharStream inputStream;
        if (this.debug) {
            inputStream = CharStreams.fromString((String)inputString);
            l = new HGVSLexer((CharStream)inputStream);
            System.err.println(l.getAllTokens());
        }
        if (this.debug) {
            HGVSLexer lexer = new HGVSLexer((CharStream)CharStreams.fromString((String)inputString));
            System.err.println("Lexer tokens");
            for (Token t : lexer.getAllTokens()) {
                System.err.println("\t" + t.getText() + "\t" + t);
            }
            System.err.println("END OF LEXER TOKENS");
        }
        inputStream = CharStreams.fromString((String)inputString);
        l = new HGVSLexer((CharStream)inputStream);
        Antlr4HGVSParser p = new Antlr4HGVSParser((TokenStream)new CommonTokenStream((TokenSource)l));
        p.setTrace(this.debug);
        p.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, e);
            }
        });
        return p;
    }
}

