/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.protein;

import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.ConvertibleToHGVSString;
import de.charite.compbio.jannovar.hgvs.Translator;

public class ProteinPointLocation
implements ConvertibleToHGVSString {
    private final String aa;
    private final int pos;
    private final int offset;
    private final boolean downstreamOfTerminal;

    public static ProteinPointLocation build(String aa, int pos) {
        return new ProteinPointLocation(aa, pos, 0, false);
    }

    public static ProteinPointLocation buildWithOffset(String aa, int pos, int offset) {
        return new ProteinPointLocation(aa, pos, offset, false);
    }

    public static ProteinPointLocation buildDownstreamOfTerminal(String aa, int pos) {
        return new ProteinPointLocation(aa, pos, 0, true);
    }

    public ProteinPointLocation(String aa, int pos, int offset, boolean downstreamOfTerminal) {
        this.aa = aa;
        this.pos = pos;
        this.offset = offset;
        this.downstreamOfTerminal = downstreamOfTerminal;
    }

    public int getPos() {
        return this.pos;
    }

    public String getAA() {
        return this.aa;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isDownstreamOfTerminal() {
        return this.downstreamOfTerminal;
    }

    @Override
    public String toHGVSString() {
        return this.toHGVSString(AminoAcidCode.THREE_LETTER);
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        String offsetStr = "";
        if (this.downstreamOfTerminal) {
            if (code == AminoAcidCode.THREE_LETTER) {
                return Translator.getTranslator().toLong(this.aa.charAt(0)) + "*" + (this.pos + 1);
            }
            return this.aa + "*" + (this.pos + 1);
        }
        if (this.offset > 0) {
            offsetStr = "+" + this.offset;
        } else if (this.offset < 0) {
            offsetStr = Integer.toString(this.offset);
        }
        if (code == AminoAcidCode.THREE_LETTER) {
            return Translator.getTranslator().toLong(this.aa.charAt(0)) + (this.pos + 1) + offsetStr;
        }
        return this.aa + (this.pos + 1) + offsetStr;
    }

    public String toString() {
        return "ProteinPointLocation [aa=" + this.aa + ", pos=" + this.pos + ", offset=" + this.offset + ", downstreamOfTerminal=" + this.downstreamOfTerminal + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aa == null ? 0 : this.aa.hashCode());
        result = 31 * result + (this.downstreamOfTerminal ? 1231 : 1237);
        result = 31 * result + this.offset;
        result = 31 * result + this.pos;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProteinPointLocation other = (ProteinPointLocation)obj;
        if (this.aa == null ? other.aa != null : !this.aa.equals(other.aa)) {
            return false;
        }
        if (this.downstreamOfTerminal != other.downstreamOfTerminal) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        return this.pos == other.pos;
    }
}

