/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.protein;

import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.ConvertibleToHGVSString;
import de.charite.compbio.jannovar.hgvs.protein.ProteinPointLocation;

public class ProteinRange
implements ConvertibleToHGVSString {
    private final ProteinPointLocation first;
    private final ProteinPointLocation last;

    public static ProteinRange build(String firstAA, int first, String lastAA, int last) {
        return new ProteinRange(ProteinPointLocation.build(firstAA, first), ProteinPointLocation.build(lastAA, last));
    }

    public static ProteinRange buildWithOffset(String firstAA, int first, int firstOffset, String lastAA, int last, int lastOffset) {
        return new ProteinRange(ProteinPointLocation.buildWithOffset(firstAA, first, firstOffset), ProteinPointLocation.buildWithOffset(lastAA, last, lastOffset));
    }

    public static ProteinRange buildDownstreamOfTerminal(String firstAA, int first, String lastAA, int last) {
        return new ProteinRange(ProteinPointLocation.buildWithOffset(firstAA, first, 0), ProteinPointLocation.buildWithOffset(lastAA, last, 0));
    }

    public ProteinRange(ProteinPointLocation first, ProteinPointLocation last) {
        this.first = first;
        this.last = last;
    }

    public ProteinPointLocation getFirst() {
        return this.first;
    }

    public ProteinPointLocation getLast() {
        return this.last;
    }

    public int length() {
        return this.last.getPos() - this.first.getPos() + 1;
    }

    @Override
    public String toHGVSString() {
        return this.toHGVSString(AminoAcidCode.THREE_LETTER);
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        if (this.first.equals(this.last)) {
            return this.first.toHGVSString(code);
        }
        return this.first.toHGVSString(code) + "_" + this.last.toHGVSString(code);
    }

    public String toString() {
        return "ProteinRange [first=" + this.first + ", last=" + this.last + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.last == null ? 0 : this.last.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProteinRange other = (ProteinRange)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        return !(this.last == null ? other.last != null : !this.last.equals(other.last));
    }
}

