/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.protein;

import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.ConvertibleToHGVSString;
import de.charite.compbio.jannovar.hgvs.Translator;

public class ProteinSeqDescription
implements ConvertibleToHGVSString {
    private final String aas;
    private final int aaCount;

    public ProteinSeqDescription() {
        this.aas = null;
        this.aaCount = -1;
    }

    public ProteinSeqDescription(int aaCount) {
        this.aas = null;
        this.aaCount = aaCount;
    }

    public ProteinSeqDescription(String aas) {
        this.aas = aas;
        this.aaCount = aas.length();
    }

    public boolean hasAminoAcids() {
        return this.aas != null;
    }

    public String getAminoAcids() {
        return this.aas;
    }

    public boolean isBlank() {
        return this.aaCount == -1;
    }

    public int length() {
        return this.aaCount;
    }

    @Override
    public String toHGVSString() {
        return this.toHGVSString(AminoAcidCode.THREE_LETTER);
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        if (this.isBlank()) {
            return "";
        }
        if (this.aas != null && code == AminoAcidCode.ONE_LETTER) {
            return this.aas;
        }
        if (this.aas != null && code == AminoAcidCode.THREE_LETTER) {
            return Translator.getTranslator().toLong(this.aas);
        }
        return Integer.toString(this.aaCount);
    }
}

