/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.protein.change;

import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.protein.ProteinRange;
import de.charite.compbio.jannovar.hgvs.protein.ProteinSeqDescription;
import de.charite.compbio.jannovar.hgvs.protein.change.ProteinChange;

public class ProteinDuplication
extends ProteinChange {
    private final ProteinRange range;
    private final ProteinSeqDescription seqSpec;

    public static ProteinDuplication buildWithoutSeqDescription(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos) {
        return new ProteinDuplication(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), new ProteinSeqDescription());
    }

    public static ProteinDuplication buildWithSequence(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos, String seq) {
        return new ProteinDuplication(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), new ProteinSeqDescription(seq));
    }

    public static ProteinDuplication buildWithLength(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos, int len) {
        return new ProteinDuplication(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), new ProteinSeqDescription(len));
    }

    public static ProteinDuplication buildWithSeqDescription(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos, ProteinSeqDescription desc) {
        return new ProteinDuplication(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), desc);
    }

    public ProteinDuplication(boolean onlyPredicted, ProteinRange range, ProteinSeqDescription seqSpec) {
        super(onlyPredicted);
        this.range = range;
        this.seqSpec = seqSpec;
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        return this.wrapIfOnlyPredicted(this.range.toHGVSString(code) + "dup" + this.seqSpec.toHGVSString(code));
    }

    public String toString() {
        return "ProteinDuplication [range=" + this.range + ", seqSpec=" + this.seqSpec + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        result = 31 * result + (this.seqSpec == null ? 0 : this.seqSpec.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProteinDuplication other = (ProteinDuplication)obj;
        if (this.range == null ? other.range != null : !this.range.equals(other.range)) {
            return false;
        }
        return !(this.seqSpec == null ? other.seqSpec != null : !this.seqSpec.equals(other.seqSpec));
    }

    @Override
    public ProteinChange withOnlyPredicted(boolean onlyPredicted) {
        return new ProteinDuplication(onlyPredicted, this.range, this.seqSpec);
    }
}

