/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.protein.change;

import com.google.common.base.Joiner;
import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.Translator;
import de.charite.compbio.jannovar.hgvs.protein.ProteinPointLocation;
import de.charite.compbio.jannovar.hgvs.protein.change.ProteinChange;

public class ProteinFrameshift
extends ProteinChange {
    public static final int LEN_NO_TER = 0;
    public static final int LEN_SHORT = 1;
    private final ProteinPointLocation position;
    private final String targetAA;
    private final int shiftLength;

    public static ProteinFrameshift build(boolean onlyPredicted, String wtAA, int position, String targetAA, int shiftLength) {
        return new ProteinFrameshift(onlyPredicted, ProteinPointLocation.build(wtAA, position), targetAA, shiftLength);
    }

    public static ProteinFrameshift build(boolean onlyPredicted, ProteinPointLocation position, String targetAA, int shiftLength) {
        return new ProteinFrameshift(onlyPredicted, position, targetAA, shiftLength);
    }

    public static ProteinFrameshift buildShort(boolean onlyPredicted, String wtAA, int position) {
        return new ProteinFrameshift(onlyPredicted, ProteinPointLocation.build(wtAA, position), null, 1);
    }

    public static ProteinFrameshift buildShort(boolean onlyPredicted, ProteinPointLocation position) {
        return new ProteinFrameshift(onlyPredicted, position, null, 1);
    }

    public static ProteinFrameshift buildWithoutTerminal(boolean onlyPredicted, String wtAA, int position, String targetAA) {
        return new ProteinFrameshift(onlyPredicted, ProteinPointLocation.build(wtAA, position), targetAA, 0);
    }

    public static ProteinFrameshift buildWithoutTerminal(boolean onlyPredicted, ProteinPointLocation position, String targetAA) {
        return new ProteinFrameshift(onlyPredicted, position, targetAA, 0);
    }

    public ProteinFrameshift(boolean onlyPredicted, ProteinPointLocation position, String targetAA, int shiftLength) {
        super(onlyPredicted);
        this.position = position;
        this.targetAA = targetAA;
        this.shiftLength = shiftLength;
    }

    public boolean isShort() {
        return this.targetAA == null || this.shiftLength == 1;
    }

    public boolean isNoTerminalFrameshfit() {
        return this.shiftLength == 0;
    }

    public ProteinPointLocation getPosition() {
        return this.position;
    }

    public String getTargetAA() {
        return this.targetAA;
    }

    public int getShiftLength() {
        return this.shiftLength;
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        String targetAA = this.targetAA;
        if (!this.isShort() && code == AminoAcidCode.THREE_LETTER) {
            targetAA = Translator.getTranslator().toLong(targetAA);
        }
        if (this.isShort()) {
            return this.wrapIfOnlyPredicted(Joiner.on((String)"").join((Object)this.position.toHGVSString(code), (Object)"fs", new Object[0]));
        }
        if (this.shiftLength == 0) {
            return this.wrapIfOnlyPredicted(Joiner.on((String)"").join((Object)this.position.toHGVSString(code), (Object)targetAA, new Object[]{"fs*?"}));
        }
        return this.wrapIfOnlyPredicted(Joiner.on((String)"").join((Object)this.position.toHGVSString(code), (Object)targetAA, new Object[]{"fs*", this.shiftLength}));
    }

    public String toString() {
        return "ProteinFrameshift [position=" + this.position + ", targetAA=" + this.targetAA + ", shiftLength=" + this.shiftLength + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        result = 31 * result + this.shiftLength;
        result = 31 * result + (this.targetAA == null ? 0 : this.targetAA.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProteinFrameshift other = (ProteinFrameshift)obj;
        if (this.position == null ? other.position != null : !this.position.equals(other.position)) {
            return false;
        }
        if (this.shiftLength != other.shiftLength) {
            return false;
        }
        return !(this.targetAA == null ? other.targetAA != null : !this.targetAA.equals(other.targetAA));
    }

    @Override
    public ProteinChange withOnlyPredicted(boolean onlyPredicted) {
        return new ProteinFrameshift(onlyPredicted, this.position, this.targetAA, this.shiftLength);
    }
}

