/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.protein.change;

import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.protein.ProteinRange;
import de.charite.compbio.jannovar.hgvs.protein.ProteinSeqDescription;
import de.charite.compbio.jannovar.hgvs.protein.change.ProteinChange;

public class ProteinInsertion
extends ProteinChange {
    private final ProteinRange position;
    private final ProteinSeqDescription seq;

    public static ProteinInsertion buildWithLength(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos) {
        return new ProteinInsertion(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), new ProteinSeqDescription());
    }

    public static ProteinInsertion buildWithLength(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos, int insertedLength) {
        return new ProteinInsertion(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), new ProteinSeqDescription(insertedLength));
    }

    public static ProteinInsertion buildWithSequence(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos, String seq) {
        return new ProteinInsertion(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), new ProteinSeqDescription(seq));
    }

    public static ProteinInsertion buildWithSeqDescription(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos, ProteinSeqDescription seqDescription) {
        return new ProteinInsertion(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), seqDescription);
    }

    public static ProteinInsertion buildWithoutSeqDescription(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos) {
        return new ProteinInsertion(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), new ProteinSeqDescription());
    }

    public ProteinInsertion(boolean onlyPredicted, ProteinRange position, ProteinSeqDescription seq) {
        super(onlyPredicted);
        this.position = position;
        this.seq = seq;
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        return this.wrapIfOnlyPredicted(this.position.toHGVSString(code) + "ins" + this.seq.toHGVSString(code));
    }

    public String toString() {
        return "ProteinInsertion [position=" + this.position + ", seq=" + this.seq + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        result = 31 * result + (this.seq == null ? 0 : this.seq.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProteinInsertion other = (ProteinInsertion)obj;
        if (this.position == null ? other.position != null : !this.position.equals(other.position)) {
            return false;
        }
        return !(this.seq == null ? other.seq != null : !this.seq.equals(other.seq));
    }

    @Override
    public ProteinChange withOnlyPredicted(boolean onlyPredicted) {
        return new ProteinInsertion(onlyPredicted, this.position, this.seq);
    }
}

