/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.protein.change;

import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.Translator;
import de.charite.compbio.jannovar.hgvs.protein.ProteinPointLocation;
import de.charite.compbio.jannovar.hgvs.protein.change.ProteinChange;

public class ProteinSubstitution
extends ProteinChange {
    private final ProteinPointLocation location;
    private final String targetAA;

    public static ProteinSubstitution build(boolean onlyPredicted, String sourceAA, int pos, String targetAA) {
        return new ProteinSubstitution(onlyPredicted, ProteinPointLocation.build(sourceAA, pos), targetAA);
    }

    public static ProteinSubstitution buildWithOffset(boolean onlyPredicted, String sourceAA, int pos, int offset, String targetAA) {
        return new ProteinSubstitution(onlyPredicted, ProteinPointLocation.buildWithOffset(sourceAA, pos, offset), targetAA);
    }

    public static ProteinSubstitution buildDownstreamOfTerminal(boolean onlyPredicted, String sourceAA, int pos, String targetAA) {
        return new ProteinSubstitution(onlyPredicted, ProteinPointLocation.buildDownstreamOfTerminal(sourceAA, pos), targetAA);
    }

    public ProteinSubstitution(boolean onlyPredicted, ProteinPointLocation location, String targetAA) {
        super(onlyPredicted);
        this.location = location;
        this.targetAA = targetAA;
    }

    public ProteinPointLocation getLocation() {
        return this.location;
    }

    public String getTargetAA() {
        return this.targetAA;
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        if (code == AminoAcidCode.THREE_LETTER) {
            return this.wrapIfOnlyPredicted(this.location.toHGVSString(code) + Translator.getTranslator().toLong(this.targetAA));
        }
        return this.wrapIfOnlyPredicted(this.location.toHGVSString(code) + this.targetAA);
    }

    public String toString() {
        return "ProteinSubstitution [location=" + this.location + ", targetAA=" + this.targetAA + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.targetAA == null ? 0 : this.targetAA.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProteinSubstitution other = (ProteinSubstitution)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        return !(this.targetAA == null ? other.targetAA != null : !this.targetAA.equals(other.targetAA));
    }

    @Override
    public ProteinChange withOnlyPredicted(boolean onlyPredicted) {
        return new ProteinSubstitution(onlyPredicted, this.location, this.targetAA);
    }
}

