/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.protein.variant;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.protein.variant.ProteinChangeAllele;
import de.charite.compbio.jannovar.hgvs.protein.variant.ProteinVariant;
import java.util.ArrayList;
import java.util.Collection;

public class MultiAlleleProteinVariant
extends ProteinVariant {
    protected final ImmutableList<ProteinChangeAllele> alleles;

    public static MultiAlleleProteinVariant build(String proteinID, ProteinChangeAllele ... alleles) {
        return new MultiAlleleProteinVariant(proteinID, (Collection<ProteinChangeAllele>)ImmutableList.copyOf((Object[])alleles));
    }

    public MultiAlleleProteinVariant(String proteinID, Collection<ProteinChangeAllele> alleles) {
        super(proteinID);
        this.alleles = ImmutableList.copyOf(alleles);
    }

    public ImmutableList<ProteinChangeAllele> getAlleles() {
        return this.alleles;
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.getSequenceNamePrefix());
        parts.add(":p.");
        boolean first = true;
        for (ProteinChangeAllele allele : this.alleles) {
            if (first) {
                first = false;
            } else {
                parts.add(";");
            }
            parts.add(allele.toHGVSString(code));
        }
        return Joiner.on((String)"").join(parts);
    }

    @Override
    public String toString() {
        return "MultiAlleleProteinVariant [alleles=" + this.alleles + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.alleles == null ? 0 : this.alleles.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiAlleleProteinVariant other = (MultiAlleleProteinVariant)obj;
        return !(this.alleles == null ? other.alleles != null : !this.alleles.equals(other.alleles));
    }
}

