/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.protein.variant;

import com.google.common.base.Joiner;
import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.HGVSVariant;

public abstract class ProteinVariant
extends HGVSVariant {
    public static final int NO_PROTEIN_ISOFORM = -1;
    protected final String refID;
    protected final String proteinID;
    protected final int proteinIsoform;

    public ProteinVariant(String refID) {
        this.refID = refID;
        this.proteinID = null;
        this.proteinIsoform = -1;
    }

    public ProteinVariant(String refID, String proteinID, int proteinIsoform) {
        this.refID = refID;
        this.proteinID = proteinID;
        this.proteinIsoform = proteinIsoform;
    }

    @Override
    public String toHGVSString() {
        return this.toHGVSString(AminoAcidCode.THREE_LETTER);
    }

    public String getProteinID() {
        return this.proteinID;
    }

    public String getSequenceNamePrefix() {
        String proteinID = this.proteinID;
        if (proteinID != null && this.proteinIsoform != -1) {
            proteinID = proteinID + "_i" + this.proteinIsoform;
        }
        if (proteinID == null) {
            return this.refID;
        }
        return Joiner.on((String)"").join((Object)this.refID, (Object)"(", new Object[]{proteinID, ")"});
    }

    public String toString() {
        return "ProteinVariant [refID=" + this.refID + ", proteinID=" + this.proteinID + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.proteinID == null ? 0 : this.proteinID.hashCode());
        result = 31 * result + this.proteinIsoform;
        result = 31 * result + (this.refID == null ? 0 : this.refID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProteinVariant other = (ProteinVariant)obj;
        if (this.proteinID == null ? other.proteinID != null : !this.proteinID.equals(other.proteinID)) {
            return false;
        }
        if (this.proteinIsoform != other.proteinIsoform) {
            return false;
        }
        return !(this.refID == null ? other.refID != null : !this.refID.equals(other.refID));
    }
}

