/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.nts;

import com.google.common.base.Joiner;
import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.ConvertibleToHGVSString;

public class NucleotidePointLocation
implements ConvertibleToHGVSString {
    final int basePos;
    final int offset;
    final boolean downstreamOfCDS;

    public static NucleotidePointLocation build(int basePos) {
        return new NucleotidePointLocation(basePos, 0, false);
    }

    public static NucleotidePointLocation buildWithOffset(int basePos, int offset) {
        return new NucleotidePointLocation(basePos, offset, false);
    }

    public static NucleotidePointLocation buildDownstreamOfCDS(int basePos) {
        return new NucleotidePointLocation(basePos, 0, true);
    }

    @Deprecated
    public NucleotidePointLocation(int basePos) {
        this.basePos = basePos;
        this.offset = 0;
        this.downstreamOfCDS = false;
    }

    public NucleotidePointLocation(int basePos, int offset, boolean downstreamOfCDS) {
        this.basePos = basePos;
        this.offset = offset;
        this.downstreamOfCDS = downstreamOfCDS;
    }

    public int getBasePos() {
        return this.basePos;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isDownstreamOfCDS() {
        return this.downstreamOfCDS;
    }

    @Override
    public String toHGVSString() {
        String prefix;
        int shift = this.basePos >= 0 ? 1 : 0;
        String string = prefix = this.downstreamOfCDS ? "*" : "";
        if (this.offset == 0) {
            return prefix + Integer.toString(this.basePos + shift);
        }
        if (this.offset > 0) {
            return prefix + Joiner.on((String)"").join((Object)(this.basePos + shift), (Object)"+", new Object[]{this.offset});
        }
        return prefix + Joiner.on((String)"").join((Object)(this.basePos + shift), (Object)"-", new Object[]{-this.offset});
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        return this.toHGVSString();
    }

    public String toString() {
        return "NucleotidePointLocation [basePos=" + this.basePos + ", offset=" + this.offset + ", downstreamOfCDS=" + this.downstreamOfCDS + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.basePos;
        result = 31 * result + (this.downstreamOfCDS ? 1231 : 1237);
        result = 31 * result + this.offset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NucleotidePointLocation other = (NucleotidePointLocation)obj;
        if (this.basePos != other.basePos) {
            return false;
        }
        if (this.downstreamOfCDS != other.downstreamOfCDS) {
            return false;
        }
        return this.offset == other.offset;
    }
}

