/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.nts;

import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.ConvertibleToHGVSString;

public class NucleotideSeqDescription
implements ConvertibleToHGVSString {
    public static final int INVALID_NT_COUNT = -1;
    private final String nts;
    private final int ntCount;

    public NucleotideSeqDescription() {
        this.nts = null;
        this.ntCount = -1;
    }

    public NucleotideSeqDescription(int ntCount) {
        this.nts = null;
        this.ntCount = ntCount;
    }

    public NucleotideSeqDescription(String nts) {
        this.nts = nts;
        this.ntCount = nts.length();
    }

    public boolean hasNucleotides() {
        return this.nts != null;
    }

    public String getNucleotides() {
        return this.nts;
    }

    public boolean isBlank() {
        return this.ntCount == -1;
    }

    public int length() {
        return this.ntCount;
    }

    @Override
    public String toHGVSString() {
        return this.toHGVSString(AminoAcidCode.THREE_LETTER);
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        if (this.isBlank()) {
            return "";
        }
        if (this.nts != null) {
            return this.nts;
        }
        return Integer.toString(this.ntCount);
    }

    public String toString() {
        return "NucleotideSeqDescription [nts=" + this.nts + ", ntCount=" + this.ntCount + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.ntCount;
        result = 31 * result + (this.nts == null ? 0 : this.nts.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NucleotideSeqDescription other = (NucleotideSeqDescription)obj;
        if (this.ntCount != other.ntCount) {
            return false;
        }
        return !(this.nts == null ? other.nts != null : !this.nts.equals(other.nts));
    }
}

