/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.nts.change;

import com.google.common.base.Joiner;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideRange;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideSeqDescription;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideChange;

public class NucleotideDeletion
extends NucleotideChange {
    private final NucleotideRange range;
    private final NucleotideSeqDescription seq;

    public static NucleotideDeletion buildWithOffset(boolean onlyPredicted, int firstPos, int firstPosOffset, int lastPos, int lastPosOffset, NucleotideSeqDescription seq) {
        return new NucleotideDeletion(onlyPredicted, NucleotideRange.build(firstPos, firstPosOffset, lastPos, lastPosOffset), seq);
    }

    public static NucleotideDeletion buildWithOffsetWithSequence(boolean onlyPredicted, int firstPos, int firstPosOffset, int lastPos, int lastPosOffset, String nts) {
        return new NucleotideDeletion(onlyPredicted, NucleotideRange.build(firstPos, firstPosOffset, lastPos, lastPosOffset), new NucleotideSeqDescription(nts));
    }

    public static NucleotideDeletion buildWithOffsetWithLength(boolean onlyPredicted, int firstPos, int firstPosOffset, int lastPos, int lastPosOffset, int seqLen) {
        return new NucleotideDeletion(onlyPredicted, NucleotideRange.build(firstPos, firstPosOffset, lastPos, lastPosOffset), new NucleotideSeqDescription(seqLen));
    }

    public static NucleotideDeletion buildWithOffsetWithoutSeqDescription(boolean onlyPredicted, int firstPos, int firstPosOffset, int lastPos, int lastPosOffset) {
        return new NucleotideDeletion(onlyPredicted, NucleotideRange.build(firstPos, firstPosOffset, lastPos, lastPosOffset), new NucleotideSeqDescription());
    }

    public static NucleotideDeletion build(boolean onlyPredicted, int firstPos, int lastPos, NucleotideSeqDescription seq) {
        return new NucleotideDeletion(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), seq);
    }

    public static NucleotideDeletion buildWithSequence(boolean onlyPredicted, int firstPos, int lastPos, String nts) {
        return new NucleotideDeletion(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), new NucleotideSeqDescription(nts));
    }

    public static NucleotideDeletion buildWithLength(boolean onlyPredicted, int firstPos, int lastPos, int seqLen) {
        return new NucleotideDeletion(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), new NucleotideSeqDescription(seqLen));
    }

    public static NucleotideDeletion buildWithoutSeqDescription(boolean onlyPredicted, int firstPos, int lastPos) {
        return new NucleotideDeletion(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), new NucleotideSeqDescription());
    }

    public NucleotideDeletion(boolean onlyPredicted, NucleotideRange range, NucleotideSeqDescription seq) {
        super(onlyPredicted);
        this.range = range;
        this.seq = seq;
    }

    @Override
    public NucleotideDeletion withOnlyPredicted(boolean flag) {
        return new NucleotideDeletion(flag, this.range, this.seq);
    }

    public NucleotideRange getRange() {
        return this.range;
    }

    public NucleotideSeqDescription getSeq() {
        return this.seq;
    }

    @Override
    public String toHGVSString() {
        return this.wrapIfOnlyPredicted(Joiner.on((String)"").join((Object)this.range.toHGVSString(), (Object)"del", new Object[]{this.seq.toHGVSString()}));
    }

    public String toString() {
        return "NucleotideDeletion [range=" + this.range + ", seq=" + this.seq + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        result = 31 * result + (this.seq == null ? 0 : this.seq.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NucleotideDeletion other = (NucleotideDeletion)obj;
        if (this.range == null ? other.range != null : !this.range.equals(other.range)) {
            return false;
        }
        return !(this.seq == null ? other.seq != null : !this.seq.equals(other.seq));
    }
}

