/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.nts.change;

import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideRange;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideChange;
import java.util.Objects;

public class NucleotideNotSequencedRepeat
extends NucleotideChange {
    private final NucleotideRange range;
    private final InDelType type;
    private final int minCount;
    private final int maxCount;

    public NucleotideNotSequencedRepeat(boolean onlyPredicted, NucleotideRange range, InDelType type, int minCount, int maxCount) {
        super(onlyPredicted);
        this.range = range;
        this.type = type;
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public NucleotideRange getRange() {
        return this.range;
    }

    public boolean isInsertion() {
        return this.type == InDelType.INS;
    }

    public boolean isDeletion() {
        return this.type == InDelType.DEL;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    @Override
    public NucleotideChange withOnlyPredicted(boolean flag) {
        return new NucleotideNotSequencedRepeat(flag, this.range, this.type, this.minCount, this.maxCount);
    }

    @Override
    public String toHGVSString() {
        StringBuilder builder = new StringBuilder(this.range.toHGVSString()).append(this.type.name().toLowerCase()).append("(").append(this.minCount);
        if (this.minCount != this.maxCount) {
            builder.append("_").append(this.maxCount);
        }
        builder.append(")");
        return this.wrapIfOnlyPredicted(builder.toString());
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        return this.toHGVSString();
    }

    public String toString() {
        return "NucleotideNotSequencedRepeat [range=" + this.range + "type=" + this.type.name() + ", minCount=" + this.minCount + ", maxCount=" + this.maxCount + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.range, this.type, this.minCount, this.maxCount});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NucleotideNotSequencedRepeat other = (NucleotideNotSequencedRepeat)obj;
        return Objects.equals(this.range, other.range) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.minCount, other.getMinCount()) && Objects.equals(this.maxCount, other.getMaxCount());
    }

    public static enum InDelType {
        INS,
        DEL;

    }
}

