/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.nts.change;

import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.ConvertibleToHGVSString;
import java.util.Objects;

public class NucleotideRepeatSequence
implements ConvertibleToHGVSString {
    final String sequence;
    final int copyNumber;

    public NucleotideRepeatSequence(String sequence, int copyNumber) {
        this.sequence = sequence;
        this.copyNumber = copyNumber;
    }

    public String getSequence() {
        return this.sequence;
    }

    public int getCopyNumber() {
        return this.copyNumber;
    }

    @Override
    public String toHGVSString() {
        return this.sequence + "[" + this.copyNumber + "]";
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        return this.toHGVSString();
    }

    public String toString() {
        return "NucleotideRepeatSequence [sequence=" + this.sequence + ", copyNumber=" + this.copyNumber + "]";
    }

    public int hashCode() {
        return Objects.hash(this.sequence, this.copyNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NucleotideRepeatSequence other = (NucleotideRepeatSequence)obj;
        return Objects.equals(this.sequence, other.sequence) && Objects.equals(this.copyNumber, other.copyNumber);
    }
}

