/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.nts.change;

import com.google.common.base.Joiner;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideRange;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideChange;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideNotSequencedRepeat;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideRepeatSequence;
import java.util.List;
import java.util.Objects;

public class NucleotideSequencedRepeat
extends NucleotideChange {
    private final NucleotideRange range;
    public List<NucleotideRepeatSequence> sequencedRepeats;
    public NucleotideNotSequencedRepeat notSequencedRepeat;

    public NucleotideSequencedRepeat(boolean onlyPredicted, NucleotideRange range, List<NucleotideRepeatSequence> sequencedRepeats) {
        super(onlyPredicted);
        this.range = range;
        this.sequencedRepeats = sequencedRepeats;
    }

    public NucleotideRange getRange() {
        return this.range;
    }

    public List<NucleotideRepeatSequence> getSequencedRepeats() {
        return this.sequencedRepeats;
    }

    public NucleotideNotSequencedRepeat getNotSequencedRepeat() {
        return this.notSequencedRepeat;
    }

    @Override
    public NucleotideChange withOnlyPredicted(boolean flag) {
        return new NucleotideSequencedRepeat(flag, this.range, this.sequencedRepeats);
    }

    @Override
    public String toHGVSString() {
        StringBuilder builder = new StringBuilder(this.range.toHGVSString());
        this.sequencedRepeats.stream().map(NucleotideRepeatSequence::toHGVSString).forEach(builder::append);
        return this.wrapIfOnlyPredicted(builder.toString());
    }

    public String toString() {
        return "NucleotideRepeat [range=" + this.range + ", sequences=(" + Joiner.on((String)", ").join(this.sequencedRepeats) + ")]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.range, this.sequencedRepeats);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NucleotideSequencedRepeat other = (NucleotideSequencedRepeat)obj;
        return super.equals(obj) && Objects.equals(this.range, other.range) && Objects.equals(this.sequencedRepeats, other.sequencedRepeats);
    }
}

