/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.nts.change;

import com.google.common.base.Joiner;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideRange;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideChange;

public class NucleotideShortSequenceRepeatVariability
extends NucleotideChange {
    private final NucleotideRange range;
    private final int minCount;
    private final int maxCount;

    public static NucleotideShortSequenceRepeatVariability build(boolean onlyPredicted, NucleotideRange range, int minCount, int maxCount) {
        return new NucleotideShortSequenceRepeatVariability(onlyPredicted, range, minCount, maxCount);
    }

    public NucleotideShortSequenceRepeatVariability(boolean onlyPredicted, NucleotideRange range, int minCount, int maxCount) {
        super(onlyPredicted);
        this.range = range;
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    @Override
    public NucleotideShortSequenceRepeatVariability withOnlyPredicted(boolean flag) {
        return new NucleotideShortSequenceRepeatVariability(flag, this.range, this.minCount, this.maxCount);
    }

    public NucleotideRange getRange() {
        return this.range;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    @Override
    public String toHGVSString() {
        return this.wrapIfOnlyPredicted(Joiner.on((String)"").join((Object)this.range.toHGVSString(), (Object)"(", new Object[]{this.minCount, "_", this.maxCount, ")"}));
    }

    public String toString() {
        return "NucleotideShortSequenceRepeatVariability [range=" + this.range + ", minCount=" + this.minCount + ", maxCount=" + this.maxCount + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.maxCount;
        result = 31 * result + this.minCount;
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NucleotideShortSequenceRepeatVariability other = (NucleotideShortSequenceRepeatVariability)obj;
        if (this.maxCount != other.maxCount) {
            return false;
        }
        if (this.minCount != other.minCount) {
            return false;
        }
        return !(this.range == null ? other.range != null : !this.range.equals(other.range));
    }
}

