/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.nts.change;

import com.google.common.base.Joiner;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideRange;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideSeqDescription;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideChange;

public class NucleotideUnchanged
extends NucleotideChange {
    private final NucleotideRange range;
    private final NucleotideSeqDescription seq;

    public static NucleotideUnchanged buildWithOffset(boolean onlyPredicted, int firstPos, int firstPosOffset, int lastPos, int lastPosOffset, NucleotideSeqDescription seq) {
        return new NucleotideUnchanged(onlyPredicted, NucleotideRange.build(firstPos, firstPosOffset, lastPos, lastPosOffset), seq);
    }

    public static NucleotideUnchanged buildWithOffsetWithSequence(boolean onlyPredicted, int firstPos, int firstPosOffset, int lastPos, int lastPosOffset, String nts) {
        return new NucleotideUnchanged(onlyPredicted, NucleotideRange.build(firstPos, firstPosOffset, lastPos, lastPosOffset), new NucleotideSeqDescription(nts));
    }

    public static NucleotideUnchanged buildWithOffsetWithLength(boolean onlyPredicted, int firstPos, int firstPosOffset, int lastPos, int lastPosOffset, int seqLen) {
        return new NucleotideUnchanged(onlyPredicted, NucleotideRange.build(firstPos, firstPosOffset, lastPos, lastPosOffset), new NucleotideSeqDescription(seqLen));
    }

    public static NucleotideUnchanged buildWithOffsetWithoutSeqDescription(boolean onlyPredicted, int firstPos, int firstPosOffset, int lastPos, int lastPosOffset) {
        return new NucleotideUnchanged(onlyPredicted, NucleotideRange.build(firstPos, firstPosOffset, lastPos, lastPosOffset), new NucleotideSeqDescription());
    }

    public static NucleotideUnchanged build(boolean onlyPredicted, int firstPos, int lastPos, NucleotideSeqDescription seq) {
        return new NucleotideUnchanged(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), seq);
    }

    public static NucleotideUnchanged buildWithSequence(boolean onlyPredicted, int firstPos, int lastPos, String nts) {
        return new NucleotideUnchanged(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), new NucleotideSeqDescription(nts));
    }

    public static NucleotideUnchanged buildWithLength(boolean onlyPredicted, int firstPos, int lastPos, int seqLen) {
        return new NucleotideUnchanged(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), new NucleotideSeqDescription(seqLen));
    }

    public static NucleotideUnchanged buildWithoutSeqDescription(boolean onlyPredicted, int firstPos, int lastPos) {
        return new NucleotideUnchanged(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), new NucleotideSeqDescription());
    }

    public NucleotideUnchanged(boolean onlyPredicted, NucleotideRange range, NucleotideSeqDescription seq) {
        super(onlyPredicted);
        this.range = range;
        this.seq = seq;
    }

    @Override
    public NucleotideUnchanged withOnlyPredicted(boolean flag) {
        return new NucleotideUnchanged(flag, this.range, this.seq);
    }

    public NucleotideRange getRange() {
        return this.range;
    }

    public NucleotideSeqDescription getSeq() {
        return this.seq;
    }

    @Override
    public String toHGVSString() {
        return this.wrapIfOnlyPredicted(Joiner.on((String)"").join((Object)this.range.toHGVSString(), (Object)this.seq.toHGVSString(), new Object[]{"="}));
    }

    public String toString() {
        return "NucleotideUnchanged [range=" + this.range + ", seq=" + this.seq + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        result = 31 * result + (this.seq == null ? 0 : this.seq.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NucleotideUnchanged other = (NucleotideUnchanged)obj;
        if (this.range == null ? other.range != null : !this.range.equals(other.range)) {
            return false;
        }
        return !(this.seq == null ? other.seq != null : !this.seq.equals(other.seq));
    }
}

