/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.nts.variant;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import de.charite.compbio.jannovar.hgvs.SequenceType;
import de.charite.compbio.jannovar.hgvs.VariantConfiguration;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideChange;
import de.charite.compbio.jannovar.hgvs.nts.variant.NucleotideChangeAllele;
import de.charite.compbio.jannovar.hgvs.nts.variant.NucleotideVariant;
import java.util.ArrayList;
import java.util.Collection;

public class SingleAlleleNucleotideVariant
extends NucleotideVariant {
    protected final NucleotideChangeAllele allele;

    public static SingleAlleleNucleotideVariant makeSingleChangeVariant(SequenceType seqType, String seqID, NucleotideChange change) {
        return new SingleAlleleNucleotideVariant(seqType, seqID, VariantConfiguration.IN_CIS, (Collection<? extends NucleotideChange>)ImmutableList.of((Object)change));
    }

    public static SingleAlleleNucleotideVariant build(SequenceType seqType, String seqID, VariantConfiguration varConfig, NucleotideChange ... changes) {
        return new SingleAlleleNucleotideVariant(seqType, seqID, varConfig, (Collection<? extends NucleotideChange>)ImmutableList.copyOf((Object[])changes));
    }

    public SingleAlleleNucleotideVariant(SequenceType seqType, String seqID, VariantConfiguration varConfig, Collection<? extends NucleotideChange> changes) {
        this(seqType, seqID, new NucleotideChangeAllele(varConfig, changes));
    }

    public SingleAlleleNucleotideVariant(SequenceType seqType, String refID, String proteinID, int transcriptVersion, NucleotideChangeAllele allele) {
        super(seqType, refID, proteinID, transcriptVersion);
        this.allele = allele;
    }

    public SingleAlleleNucleotideVariant(SequenceType seqType, String seqID, NucleotideChangeAllele allele) {
        super(seqType, seqID);
        this.allele = allele;
    }

    public boolean hasOnlyOneChange() {
        return this.allele.size() == 1;
    }

    public NucleotideChange getChange() {
        return this.allele.get(0);
    }

    public NucleotideChangeAllele getAllele() {
        return this.allele;
    }

    @Override
    public String toHGVSString() {
        if (this.hasOnlyOneChange()) {
            return Joiner.on((String)"").join((Object)this.getSequenceNamePrefix(), (Object)":", new Object[]{this.seqType.getPrefix(), this.getChange().toHGVSString()});
        }
        String sep = this.allele.getVarConfig().toHGVSSeparator();
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.getSequenceNamePrefix());
        parts.add(":");
        parts.add(this.seqType.getPrefix());
        if (this.hasOnlyOneChange()) {
            parts.add(this.getChange().toHGVSString());
        } else {
            parts.add("[");
            boolean first = true;
            for (NucleotideChange change : this.allele) {
                if (first) {
                    first = false;
                } else {
                    parts.add(sep);
                }
                parts.add(change.toHGVSString());
            }
            parts.add("]");
        }
        return Joiner.on((String)"").join(parts);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.allele == null ? 0 : this.allele.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleAlleleNucleotideVariant other = (SingleAlleleNucleotideVariant)obj;
        return !(this.allele == null ? other.allele != null : !this.allele.equals(other.allele));
    }
}

