/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.parser;

import de.charite.compbio.jannovar.hgvs.HGVSVariant;
import de.charite.compbio.jannovar.hgvs.SequenceType;
import de.charite.compbio.jannovar.hgvs.VariantConfiguration;
import de.charite.compbio.jannovar.hgvs.legacy.LegacyChange;
import de.charite.compbio.jannovar.hgvs.legacy.LegacyDeletion;
import de.charite.compbio.jannovar.hgvs.legacy.LegacyIndel;
import de.charite.compbio.jannovar.hgvs.legacy.LegacyInsertion;
import de.charite.compbio.jannovar.hgvs.legacy.LegacyLocation;
import de.charite.compbio.jannovar.hgvs.legacy.LegacySubstitution;
import de.charite.compbio.jannovar.hgvs.legacy.LegacyVariant;
import de.charite.compbio.jannovar.hgvs.nts.NucleotidePointLocation;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideRange;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideSeqDescription;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideChange;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideDeletion;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideDuplication;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideIndel;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideInsertion;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideInversion;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideMiscChange;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideNotSequencedRepeat;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideRepeatSequence;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideSequencedRepeat;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideShortSequenceRepeatVariability;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideSubstitution;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideUnchanged;
import de.charite.compbio.jannovar.hgvs.nts.variant.MultiAlleleNucleotideVariant;
import de.charite.compbio.jannovar.hgvs.nts.variant.NucleotideChangeAllele;
import de.charite.compbio.jannovar.hgvs.nts.variant.SingleAlleleNucleotideVariant;
import de.charite.compbio.jannovar.hgvs.parser.Antlr4HGVSParser;
import de.charite.compbio.jannovar.hgvs.parser.Antlr4HGVSParserBaseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Antlr4HGVSParserListenerImpl
extends Antlr4HGVSParserBaseListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Antlr4HGVSParserListenerImpl.class);
    ParseTreeProperty<Object> values = new ParseTreeProperty();
    HGVSVariant hgvsVariant = null;
    LegacyVariant legacyVariant = null;

    Antlr4HGVSParserListenerImpl() {
    }

    public void setValue(ParseTree node, Object value) {
        this.values.put(node, value);
    }

    public Object getValue(ParseTree node) {
        return this.values.get(node);
    }

    public HGVSVariant getHGVSVariant() {
        return this.hgvsVariant;
    }

    public LegacyVariant getLegacyVariant() {
        return this.legacyVariant;
    }

    @Override
    public void exitHgvs_variant(Antlr4HGVSParser.Hgvs_variantContext ctx) {
        LOGGER.debug("Leaving hgvs_variant");
        this.hgvsVariant = (HGVSVariant)this.getValue(ctx.getChild(0));
    }

    @Override
    public void exitNt_single_allele_var(Antlr4HGVSParser.Nt_single_allele_varContext ctx) {
        LOGGER.debug("Leaving nt_single_allele_var");
        this.setValue((ParseTree)ctx, this.getValue(ctx.getChild(0)));
    }

    @Override
    public void exitNt_single_allele_single_change_var(Antlr4HGVSParser.Nt_single_allele_single_change_varContext ctx) {
        LOGGER.debug("Leaving nt_single_allele_single_change_var");
        SequenceType seqType = SequenceType.findMatchingForPrefix(ctx.NT_CHANGE_DESCRIPTION().getText());
        ReferenceLabel refLabel = (ReferenceLabel)this.getValue((ParseTree)ctx.reference());
        NucleotideChange ntChange = (NucleotideChange)this.getValue((ParseTree)ctx.nt_change());
        this.setValue((ParseTree)ctx, new SingleAlleleNucleotideVariant(seqType, refLabel.getTranscriptID(), refLabel.getProteinID(), refLabel.getTranscriptVersion(), NucleotideChangeAllele.singleChangeAllele(ntChange)));
    }

    @Override
    public void exitNt_single_allele_multi_change_var(Antlr4HGVSParser.Nt_single_allele_multi_change_varContext ctx) {
        LOGGER.debug("Leaving nt_single_allele_multi_change_var");
        SequenceType seqType = SequenceType.findMatchingForPrefix(ctx.NT_CHANGE_DESCRIPTION().getText());
        ReferenceLabel refLabel = (ReferenceLabel)this.getValue((ParseTree)ctx.reference());
        NucleotideChangeAllele allele = (NucleotideChangeAllele)this.getValue((ParseTree)ctx.nt_multi_change_allele());
        this.setValue((ParseTree)ctx, new SingleAlleleNucleotideVariant(seqType, refLabel.getTranscriptID(), refLabel.getProteinID(), refLabel.getTranscriptVersion(), allele));
    }

    @Override
    public void exitNt_multi_allele_var(Antlr4HGVSParser.Nt_multi_allele_varContext ctx) {
        LOGGER.debug("Leaving nt_multi_allele_var");
        ArrayList<NucleotideChangeAllele> alleles = new ArrayList<NucleotideChangeAllele>();
        for (Antlr4HGVSParser.Nt_multi_change_alleleContext childCtx : ctx.nt_multi_change_allele()) {
            alleles.add((NucleotideChangeAllele)this.getValue((ParseTree)childCtx));
        }
        SequenceType seqType = SequenceType.findMatchingForPrefix(ctx.NT_CHANGE_DESCRIPTION().getText());
        ReferenceLabel refLabel = (ReferenceLabel)this.getValue((ParseTree)ctx.reference());
        this.setValue((ParseTree)ctx, new MultiAlleleNucleotideVariant(seqType, refLabel.getTranscriptID(), refLabel.getProteinID(), refLabel.getTranscriptVersion(), alleles));
    }

    @Override
    public void exitNt_multi_change_allele(Antlr4HGVSParser.Nt_multi_change_alleleContext ctx) {
        LOGGER.debug("Leaving nt_multi_change_allele");
        if (ctx.NT_PAREN_OPEN() == null) {
            this.setValue((ParseTree)ctx, this.getValue((ParseTree)ctx.nt_multi_change_allele_inner()));
        } else {
            NucleotideChangeAllele allele = (NucleotideChangeAllele)this.getValue((ParseTree)ctx.nt_multi_change_allele_inner());
            this.setValue((ParseTree)ctx, allele.withOnlyPredicted(true));
        }
    }

    @Override
    public void exitNt_multi_change_allele_inner(Antlr4HGVSParser.Nt_multi_change_allele_innerContext ctx) {
        LOGGER.debug("Leaving nt_multi_change_allele_inner");
        VariantConfiguration varConfig = VariantConfiguration.IN_CIS;
        if (!ctx.nt_var_sep().isEmpty()) {
            Antlr4HGVSParser.Nt_var_sepContext firstSep = ctx.nt_var_sep().get(0);
            for (Antlr4HGVSParser.Nt_var_sepContext otherSep : ctx.nt_var_sep()) {
                if (firstSep.getText().equals(otherSep.getText())) continue;
                throw new RuntimeException("Mismatching variant separators in allele: " + firstSep.getText() + " vs. " + otherSep.getText());
            }
            varConfig = VariantConfiguration.fromString(firstSep.getText());
        }
        ArrayList<NucleotideChange> changes = new ArrayList<NucleotideChange>();
        for (Antlr4HGVSParser.Nt_changeContext childCtx : ctx.nt_change()) {
            changes.add((NucleotideChange)this.getValue((ParseTree)childCtx));
        }
        this.setValue((ParseTree)ctx, new NucleotideChangeAllele(varConfig, changes));
    }

    @Override
    public void exitNt_change(Antlr4HGVSParser.Nt_changeContext ctx) {
        LOGGER.debug("Leaving nt_change");
        if (ctx.NT_PAREN_OPEN() == null) {
            this.setValue((ParseTree)ctx, this.getValue((ParseTree)ctx.nt_change_inner()));
        } else {
            NucleotideChange change = (NucleotideChange)this.getValue((ParseTree)ctx.nt_change_inner());
            this.setValue((ParseTree)ctx, change.withOnlyPredicted(true));
        }
    }

    @Override
    public void exitNt_change_inner(Antlr4HGVSParser.Nt_change_innerContext ctx) {
        LOGGER.debug("Leaving nt_change_inner");
        this.setValue((ParseTree)ctx, this.getValue(ctx.getChild(0)));
    }

    @Override
    public void exitNt_change_indel(Antlr4HGVSParser.Nt_change_indelContext ctx) {
        boolean hasOnlyDelBases;
        boolean hasBoth;
        LOGGER.debug("Leaving nt_change_deletion");
        NucleotideRange range = ctx.nt_range() != null ? (NucleotideRange)this.getValue((ParseTree)ctx.nt_range()) : new NucleotideRange((NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_point_location()), (NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_point_location()));
        boolean hasAny = ctx.nt_number(0) != null || ctx.nt_string(0) != null;
        boolean bl = hasBoth = hasAny && (ctx.nt_number(1) != null || ctx.nt_string(1) != null);
        if (hasAny && !hasBoth) {
            ParserRuleContext singleton = ctx.nt_number(0) != null ? ctx.nt_number(0) : ctx.nt_string(0);
            int singletonStart = singleton.getSourceInterval().a;
            int insStart = ctx.NT_INS().getSourceInterval().a;
            hasOnlyDelBases = singletonStart < insStart;
        } else {
            hasOnlyDelBases = false;
        }
        ParserRuleContext delBases = (hasBoth || hasOnlyDelBases) && ctx.nt_number(0) != null ? ctx.nt_number(0) : ((hasBoth || hasOnlyDelBases) && ctx.nt_string(0) != null ? ctx.nt_string(0) : null);
        ParserRuleContext insBases = hasBoth && ctx.nt_number(1) != null ? ctx.nt_number(1) : (!hasBoth && !hasOnlyDelBases && ctx.nt_number(0) != null ? ctx.nt_number(0) : (hasBoth && ctx.nt_string(1) != null ? ctx.nt_string(1) : (!hasBoth && !hasOnlyDelBases && ctx.nt_string(0) != null ? ctx.nt_string(0) : null)));
        NucleotideSeqDescription seqDesc1 = delBases != null && delBases == ctx.nt_number(0) ? new NucleotideSeqDescription(Integer.parseInt(ctx.nt_number(0).getText())) : (delBases != null && delBases == ctx.nt_string(0) ? new NucleotideSeqDescription(ctx.nt_string(0).getText()) : new NucleotideSeqDescription());
        NucleotideSeqDescription seqDesc2 = insBases != null && (insBases == ctx.nt_number(0) || insBases == ctx.nt_number(1)) ? new NucleotideSeqDescription(Integer.parseInt(insBases.getText())) : (insBases != null && (insBases == ctx.nt_string(0) || insBases == ctx.nt_string(1)) ? new NucleotideSeqDescription(insBases.getText()) : new NucleotideSeqDescription());
        this.setValue((ParseTree)ctx, new NucleotideIndel(false, range, seqDesc1, seqDesc2));
    }

    @Override
    public void exitNt_change_deletion(Antlr4HGVSParser.Nt_change_deletionContext ctx) {
        LOGGER.debug("Leaving nt_change_deletion");
        NucleotideRange range = ctx.nt_range() != null ? (NucleotideRange)this.getValue((ParseTree)ctx.nt_range()) : new NucleotideRange((NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_point_location()), (NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_point_location()));
        NucleotideDeletion change = ctx.nt_number() != null ? new NucleotideDeletion(false, range, new NucleotideSeqDescription(Integer.parseInt(ctx.nt_number().getText()))) : (ctx.nt_string() != null ? new NucleotideDeletion(false, range, new NucleotideSeqDescription(ctx.nt_string().getText())) : new NucleotideDeletion(false, range, new NucleotideSeqDescription()));
        this.setValue((ParseTree)ctx, change);
    }

    @Override
    public void exitNt_change_unchanged(Antlr4HGVSParser.Nt_change_unchangedContext ctx) {
        LOGGER.debug("Leaving nt_change_unchanged");
        NucleotideRange range = ctx.nt_range() != null ? (NucleotideRange)this.getValue((ParseTree)ctx.nt_range()) : new NucleotideRange((NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_point_location()), (NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_point_location()));
        NucleotideUnchanged change = ctx.nt_string() != null ? new NucleotideUnchanged(false, range, new NucleotideSeqDescription(ctx.nt_string().getText())) : new NucleotideUnchanged(false, range, new NucleotideSeqDescription());
        this.setValue((ParseTree)ctx, change);
    }

    @Override
    public void exitNt_change_duplication(Antlr4HGVSParser.Nt_change_duplicationContext ctx) {
        LOGGER.debug("Leaving nt_change_duplication");
        NucleotideRange range = ctx.nt_range() != null ? (NucleotideRange)this.getValue((ParseTree)ctx.nt_range()) : new NucleotideRange((NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_point_location()), (NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_point_location()));
        NucleotideDuplication change = ctx.nt_number() != null ? new NucleotideDuplication(false, range, new NucleotideSeqDescription(Integer.parseInt(ctx.nt_number().getText()))) : (ctx.nt_string() != null ? new NucleotideDuplication(false, range, new NucleotideSeqDescription(ctx.nt_string().getText())) : new NucleotideDuplication(false, range, new NucleotideSeqDescription()));
        this.setValue((ParseTree)ctx, change);
    }

    @Override
    public void exitNt_change_insertion(Antlr4HGVSParser.Nt_change_insertionContext ctx) {
        LOGGER.debug("Leaving nt_change_insertion");
        NucleotideRange range = (NucleotideRange)this.getValue((ParseTree)ctx.nt_range());
        NucleotideInsertion change = ctx.nt_number() != null ? new NucleotideInsertion(false, range, new NucleotideSeqDescription(Integer.parseInt(ctx.nt_number().getText()))) : (ctx.nt_string() != null ? new NucleotideInsertion(false, range, new NucleotideSeqDescription(ctx.nt_string().getText())) : new NucleotideInsertion(false, range, new NucleotideSeqDescription()));
        this.setValue((ParseTree)ctx, change);
    }

    @Override
    public void exitNt_change_inversion(Antlr4HGVSParser.Nt_change_inversionContext ctx) {
        LOGGER.debug("Leaving nt_change_inversion");
        NucleotideRange range = (NucleotideRange)this.getValue((ParseTree)ctx.nt_range());
        NucleotideInversion change = ctx.nt_number() != null ? new NucleotideInversion(false, range, new NucleotideSeqDescription(Integer.parseInt(ctx.nt_number().getText()))) : (ctx.nt_string() != null ? new NucleotideInversion(false, range, new NucleotideSeqDescription(ctx.nt_string().getText())) : new NucleotideInversion(false, range, new NucleotideSeqDescription()));
        this.setValue((ParseTree)ctx, change);
    }

    @Override
    public void exitNt_change_substitution(Antlr4HGVSParser.Nt_change_substitutionContext ctx) {
        LOGGER.debug("Leaving nt_change_substitution");
        NucleotidePointLocation position = (NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_point_location());
        this.setValue((ParseTree)ctx, new NucleotideSubstitution(false, position, ctx.NT_STRING(0).getText(), ctx.NT_STRING(1).getText()));
    }

    @Override
    public void exitNt_change_ssr(Antlr4HGVSParser.Nt_change_ssrContext ctx) {
        LOGGER.debug("Leaving nt_change_ssr");
        NucleotideRange range = ctx.nt_range() != null ? (NucleotideRange)this.getValue((ParseTree)ctx.nt_range()) : new NucleotideRange((NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_point_location()), (NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_point_location()));
        int minCount = Integer.parseInt(ctx.NT_NUMBER(0).getText());
        int maxCount = Integer.parseInt(ctx.NT_NUMBER(1).getText());
        this.setValue((ParseTree)ctx, new NucleotideShortSequenceRepeatVariability(false, range, minCount, maxCount));
    }

    @Override
    public void exitNt_change_sequenced_repeat(Antlr4HGVSParser.Nt_change_sequenced_repeatContext ctx) {
        LOGGER.debug("Leaving nt_change_sequenced_repeat");
        NucleotideRange range = ctx.nt_range() != null ? (NucleotideRange)this.getValue((ParseTree)ctx.nt_range()) : new NucleotideRange((NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_point_location()), (NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_point_location()));
        List sequences = null;
        if (ctx.nt_change_repeat_sequence() != null) {
            sequences = ctx.nt_change_repeat_sequence().stream().map(rsc -> (NucleotideRepeatSequence)this.getValue((ParseTree)rsc)).collect(Collectors.toList());
        }
        this.setValue((ParseTree)ctx, new NucleotideSequencedRepeat(false, range, sequences));
    }

    @Override
    public void exitNt_change_repeat_sequence(Antlr4HGVSParser.Nt_change_repeat_sequenceContext ctx) {
        LOGGER.debug("Leaving nt_change_repeat_sequence");
        String sequence = ctx.NT_STRING().getText();
        int copyNumber = Integer.parseInt(ctx.NT_NUMBER().getText());
        this.setValue((ParseTree)ctx, new NucleotideRepeatSequence(sequence, copyNumber));
    }

    @Override
    public void exitNt_change_not_sequenced_repeat(Antlr4HGVSParser.Nt_change_not_sequenced_repeatContext ctx) {
        int minCount;
        LOGGER.debug("Leaving nt_change_not_sequenced_repeat");
        NucleotideRange range = ctx.nt_range() != null ? (NucleotideRange)this.getValue((ParseTree)ctx.nt_range()) : new NucleotideRange((NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_point_location()), (NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_point_location()));
        NucleotideNotSequencedRepeat.InDelType type = NucleotideNotSequencedRepeat.InDelType.INS;
        if (ctx.NT_DEL() != null) {
            type = NucleotideNotSequencedRepeat.InDelType.DEL;
        }
        int maxCount = minCount = Integer.parseInt(ctx.NT_NUMBER(0).getText());
        if (ctx.NT_NUMBER().size() > 1) {
            maxCount = Integer.parseInt(ctx.NT_NUMBER(1).getText());
        }
        this.setValue((ParseTree)ctx, new NucleotideNotSequencedRepeat(false, range, type, minCount, maxCount));
    }

    @Override
    public void exitNt_change_misc(Antlr4HGVSParser.Nt_change_miscContext ctx) {
        LOGGER.debug("Leaving nt_change_misc");
        this.setValue((ParseTree)ctx, NucleotideMiscChange.buildFromString(ctx.getText()));
    }

    @Override
    public void exitReference(Antlr4HGVSParser.ReferenceContext ctx) {
        LOGGER.debug("Leaving reference");
        int transcriptVersion = -1;
        String proteinID = null;
        String transcriptID = ctx.REFERENCE(0).getText();
        if (transcriptID.contains(".")) {
            int pos = transcriptID.lastIndexOf(46);
            transcriptVersion = Integer.parseInt(transcriptID.substring(pos + 1));
            transcriptID = transcriptID.substring(0, pos);
        }
        if (ctx.PAREN_OPEN() != null) {
            proteinID = ctx.REFERENCE(1).getText();
        }
        this.setValue((ParseTree)ctx, new ReferenceLabel(transcriptID, transcriptVersion, proteinID));
    }

    @Override
    public void exitNt_range(Antlr4HGVSParser.Nt_rangeContext ctx) {
        LOGGER.debug("Leaving nt_range");
        NucleotidePointLocation startPos = (NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_point_location(0));
        NucleotidePointLocation stopPos = (NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_point_location(1));
        this.setValue((ParseTree)ctx, new NucleotideRange(startPos, stopPos));
    }

    @Override
    public void exitNt_point_location(Antlr4HGVSParser.Nt_point_locationContext ctx) {
        LOGGER.debug("Leaving nt_point_location");
        if (ctx.nt_offset() == null) {
            this.setValue((ParseTree)ctx, this.getValue((ParseTree)ctx.nt_base_location()));
        } else {
            NucleotidePointLocation baseLoc = (NucleotidePointLocation)this.getValue((ParseTree)ctx.nt_base_location());
            Integer offset = (Integer)this.getValue((ParseTree)ctx.nt_offset());
            this.setValue((ParseTree)ctx, new NucleotidePointLocation(baseLoc.getBasePos(), offset, baseLoc.isDownstreamOfCDS()));
        }
    }

    @Override
    public void exitNt_base_location(Antlr4HGVSParser.Nt_base_locationContext ctx) {
        LOGGER.debug("Leaving nt_base_location");
        int value = Integer.parseInt(ctx.nt_number().getText());
        if (ctx.NT_MINUS() != null) {
            value = -value;
        }
        boolean downstreamOfCDS = ctx.NT_ASTERISK() != null;
        int delta = value < 0 ? 0 : 1;
        this.setValue((ParseTree)ctx, new NucleotidePointLocation(value - delta, 0, downstreamOfCDS));
    }

    @Override
    public void exitNt_offset(Antlr4HGVSParser.Nt_offsetContext ctx) {
        LOGGER.debug("Leaving nt_offset");
        int value = Integer.parseInt(ctx.nt_number().getText());
        if (ctx.NT_MINUS() != null) {
            value = -value;
        }
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitLegacy_variant(Antlr4HGVSParser.Legacy_variantContext ctx) {
        LOGGER.debug("Leaving legacy_variant");
        String ref = ctx.reference().REFERENCE(0).getText();
        LegacyChange change = (LegacyChange)this.getValue(ctx.getChild(1));
        this.legacyVariant = new LegacyVariant(ref, change);
    }

    @Override
    public void exitLegacy_change(Antlr4HGVSParser.Legacy_changeContext ctx) {
        LOGGER.debug("Leaving legacy_change");
        this.setValue((ParseTree)ctx, this.getValue(ctx.getChild(0)));
    }

    @Override
    public void exitLegacy_change_deletion(Antlr4HGVSParser.Legacy_change_deletionContext ctx) {
        LOGGER.debug("Leaving legacy_change_deletion");
        LegacyLocation location = (LegacyLocation)this.getValue((ParseTree)ctx.legacy_point_location());
        NucleotideSeqDescription seqDesc = ctx.nt_number() != null ? new NucleotideSeqDescription(Integer.parseInt(ctx.nt_number().getText())) : (ctx.nt_string() != null ? new NucleotideSeqDescription(ctx.nt_string().getText()) : new NucleotideSeqDescription());
        this.setValue((ParseTree)ctx, new LegacyDeletion(location, seqDesc));
    }

    @Override
    public void exitLegacy_change_substitution(Antlr4HGVSParser.Legacy_change_substitutionContext ctx) {
        LOGGER.debug("Leaving legacy_change_substitution");
        LegacyLocation location = (LegacyLocation)this.getValue((ParseTree)ctx.legacy_point_location());
        String from = ctx.NT_STRING(0).getText();
        String to = ctx.NT_STRING(1).getText();
        this.setValue((ParseTree)ctx, new LegacySubstitution(location, from, to));
    }

    @Override
    public void exitLegacy_change_indel(Antlr4HGVSParser.Legacy_change_indelContext ctx) {
        LOGGER.debug("Leaving legacy_change_insertion");
        LegacyLocation location = (LegacyLocation)this.getValue((ParseTree)ctx.legacy_point_location());
        NucleotideSeqDescription seqDesc1 = ctx.nt_number(0) != null ? new NucleotideSeqDescription(Integer.parseInt(ctx.nt_number(0).getText())) : (ctx.nt_string(0) != null ? new NucleotideSeqDescription(ctx.nt_string(0).getText()) : new NucleotideSeqDescription());
        NucleotideSeqDescription seqDesc2 = ctx.nt_number(1) != null ? new NucleotideSeqDescription(Integer.parseInt(ctx.nt_number(1).getText())) : (ctx.nt_string(1) != null ? new NucleotideSeqDescription(ctx.nt_string(1).getText()) : new NucleotideSeqDescription());
        this.setValue((ParseTree)ctx, new LegacyIndel(location, seqDesc1, seqDesc2));
    }

    @Override
    public void exitLegacy_change_insertion(Antlr4HGVSParser.Legacy_change_insertionContext ctx) {
        LOGGER.debug("Leaving legacy_change_insertion");
        LegacyLocation location = (LegacyLocation)this.getValue((ParseTree)ctx.legacy_point_location());
        NucleotideSeqDescription seqDesc = ctx.nt_number() != null ? new NucleotideSeqDescription(Integer.parseInt(ctx.nt_number().getText())) : (ctx.nt_string() != null ? new NucleotideSeqDescription(ctx.nt_string().getText()) : new NucleotideSeqDescription());
        this.setValue((ParseTree)ctx, new LegacyInsertion(location, seqDesc));
    }

    @Override
    public void exitLegacy_point_location(Antlr4HGVSParser.Legacy_point_locationContext ctx) {
        LOGGER.debug("Leaving legacy_point_location");
        int featureNo = Integer.parseInt(ctx.nt_number(0).getText());
        int offset = Integer.parseInt(ctx.nt_number(1).getText());
        if (ctx.NT_MINUS() != null) {
            offset = -offset;
        }
        if (ctx.LEGACY_IVS_OR_EX().getText().equals("IVS")) {
            this.setValue((ParseTree)ctx, LegacyLocation.buildIntronicLocation(featureNo, offset));
        } else {
            this.setValue((ParseTree)ctx, LegacyLocation.buildExonicLocation(featureNo, offset));
        }
    }

    private static class ReferenceLabel {
        private final String transcriptID;
        private final int transcriptVersion;
        private final String proteinID;

        public ReferenceLabel(String transcriptID, int transcriptVersion, String proteinID) {
            this.transcriptID = transcriptID;
            this.transcriptVersion = transcriptVersion;
            this.proteinID = proteinID;
        }

        public String getTranscriptID() {
            return this.transcriptID;
        }

        public int getTranscriptVersion() {
            return this.transcriptVersion;
        }

        public String getProteinID() {
            return this.proteinID;
        }
    }
}

