/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.protein.change;

import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.protein.ProteinRange;
import de.charite.compbio.jannovar.hgvs.protein.ProteinSeqDescription;
import de.charite.compbio.jannovar.hgvs.protein.change.ProteinChange;

public class ProteinDeletion
extends ProteinChange {
    private final ProteinRange range;
    private final ProteinSeqDescription seqDesc;

    public static ProteinDeletion buildWithoutSeqDescription(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos) {
        return new ProteinDeletion(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos));
    }

    public static ProteinDeletion buildWithLength(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos, int length) {
        return new ProteinDeletion(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), length);
    }

    public static ProteinDeletion buildWithSequence(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos, String seq) {
        return new ProteinDeletion(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), seq);
    }

    public ProteinDeletion(boolean onlyPredicted, ProteinRange range) {
        super(onlyPredicted);
        this.range = range;
        this.seqDesc = new ProteinSeqDescription();
    }

    public ProteinDeletion(boolean onlyPredicted, ProteinRange range, int length) {
        super(onlyPredicted);
        this.range = range;
        this.seqDesc = new ProteinSeqDescription(length);
    }

    public ProteinDeletion(boolean onlyPredicted, ProteinRange range, String seq) {
        super(onlyPredicted);
        this.range = range;
        this.seqDesc = new ProteinSeqDescription(seq);
    }

    private ProteinDeletion(boolean onlyPredicted, ProteinRange range, ProteinSeqDescription seqDesc) {
        super(onlyPredicted);
        this.range = range;
        this.seqDesc = seqDesc;
    }

    public ProteinRange getRange() {
        return this.range;
    }

    public ProteinSeqDescription getSeqDesc() {
        return this.seqDesc;
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        return this.wrapIfOnlyPredicted(this.range.toHGVSString(code) + "del" + this.seqDesc.toHGVSString(code));
    }

    @Override
    public ProteinChange withOnlyPredicted(boolean onlyPredicted) {
        return new ProteinDeletion(onlyPredicted, this.range, this.seqDesc);
    }
}

