/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.protein.change;

import com.google.common.base.Joiner;
import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.Translator;
import de.charite.compbio.jannovar.hgvs.protein.ProteinPointLocation;
import de.charite.compbio.jannovar.hgvs.protein.change.ProteinChange;

public class ProteinExtension
extends ProteinChange {
    public static final int LEN_NO_TER = 0;
    private final ProteinPointLocation position;
    private final String targetAA;
    private final int shift;

    public static ProteinExtension build(boolean onlyPredicted, String wtAA, int pos, String targetAA, int shift) {
        return ProteinExtension.build(onlyPredicted, ProteinPointLocation.build(wtAA, pos), targetAA, shift);
    }

    public static ProteinExtension build(boolean onlyPredicted, ProteinPointLocation position, String targetAA, int shift) {
        return new ProteinExtension(onlyPredicted, position, targetAA, shift);
    }

    public static ProteinExtension buildWithoutTerminal(boolean onlyPredicted, String wtAA, int pos, String targetAA) {
        return new ProteinExtension(onlyPredicted, ProteinPointLocation.build(wtAA, pos), targetAA, 0);
    }

    public static ProteinExtension buildWithoutTerminal(boolean onlyPredicted, ProteinPointLocation position, String targetAA) {
        return new ProteinExtension(onlyPredicted, position, targetAA, 0);
    }

    public ProteinExtension(boolean onlyPredicted, ProteinPointLocation position, String targetAA, int shift) {
        super(onlyPredicted);
        this.position = position;
        this.targetAA = targetAA;
        this.shift = shift;
    }

    public ProteinPointLocation getPosition() {
        return this.position;
    }

    public String getTargetAA() {
        return this.targetAA;
    }

    public int getShift() {
        return this.shift;
    }

    public boolean isNoTerminalExtension() {
        return this.shift == 0;
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        String targetAA = this.targetAA;
        if (code == AminoAcidCode.THREE_LETTER) {
            targetAA = Translator.getTranslator().toLong(targetAA);
        }
        if (this.isNoTerminalExtension()) {
            return this.wrapIfOnlyPredicted(Joiner.on((String)"").join((Object)this.position.toHGVSString(code), (Object)targetAA, new Object[]{"ext*?"}));
        }
        return this.wrapIfOnlyPredicted(Joiner.on((String)"").join((Object)this.position.toHGVSString(code), (Object)targetAA, new Object[]{"ext*", this.shift}));
    }

    public String toString() {
        return "ProteinExtension [position=" + this.position + ", targetAA=" + this.targetAA + ", shift=" + this.shift + ", toHGVSString()=" + this.toHGVSString() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        result = 31 * result + this.shift;
        result = 31 * result + (this.targetAA == null ? 0 : this.targetAA.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProteinExtension other = (ProteinExtension)obj;
        if (this.position == null ? other.position != null : !this.position.equals(other.position)) {
            return false;
        }
        if (this.shift != other.shift) {
            return false;
        }
        return !(this.targetAA == null ? other.targetAA != null : !this.targetAA.equals(other.targetAA));
    }

    @Override
    public ProteinChange withOnlyPredicted(boolean onlyPredicted) {
        return new ProteinExtension(onlyPredicted, this.position, this.targetAA, this.shift);
    }
}

