/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.protein.change;

import com.google.common.base.Joiner;
import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.protein.ProteinRange;
import de.charite.compbio.jannovar.hgvs.protein.ProteinSeqDescription;
import de.charite.compbio.jannovar.hgvs.protein.change.ProteinChange;

public class ProteinIndel
extends ProteinChange {
    private final ProteinRange range;
    private final ProteinSeqDescription delSeq;
    private final ProteinSeqDescription insSeq;

    public static ProteinIndel buildWithoutSeqDescription(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos) {
        return new ProteinIndel(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), new ProteinSeqDescription(), new ProteinSeqDescription());
    }

    public static ProteinIndel buildWithLength(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos, int deletedLength, int insertedLength) {
        return new ProteinIndel(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), new ProteinSeqDescription(deletedLength), new ProteinSeqDescription(insertedLength));
    }

    public static ProteinIndel buildWithSequence(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos, String deletedSeq, String insertedSeq) {
        return new ProteinIndel(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), new ProteinSeqDescription(deletedSeq), new ProteinSeqDescription(insertedSeq));
    }

    public static ProteinIndel buildWithSeqDescription(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos, ProteinSeqDescription delDesc, ProteinSeqDescription insDesc) {
        return new ProteinIndel(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), delDesc, insDesc);
    }

    public ProteinIndel(boolean onlyPredicted, ProteinRange range, ProteinSeqDescription delSeq, ProteinSeqDescription insSeq) {
        super(onlyPredicted);
        this.range = range;
        this.delSeq = delSeq;
        this.insSeq = insSeq;
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        String open = this.isOnlyPredicted() ? "(" : "";
        String close = this.isOnlyPredicted() ? ")" : "";
        return Joiner.on((String)"").skipNulls().join((Object)open, (Object)this.range.toHGVSString(code), new Object[]{"del", this.delSeq.toHGVSString(code), "ins", this.insSeq.toHGVSString(code), close});
    }

    public String toString() {
        return "ProteinIndel [range=" + this.range + ", delSeq=" + this.delSeq + ", insSeq=" + this.insSeq + "]";
    }

    public ProteinRange getRange() {
        return this.range;
    }

    public ProteinSeqDescription getSeq() {
        return this.insSeq;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delSeq == null ? 0 : this.delSeq.hashCode());
        result = 31 * result + (this.insSeq == null ? 0 : this.insSeq.hashCode());
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProteinIndel other = (ProteinIndel)obj;
        if (this.delSeq == null ? other.delSeq != null : !this.delSeq.equals(other.delSeq)) {
            return false;
        }
        if (this.insSeq == null ? other.insSeq != null : !this.insSeq.equals(other.insSeq)) {
            return false;
        }
        return !(this.range == null ? other.range != null : !this.range.equals(other.range));
    }

    @Override
    public ProteinChange withOnlyPredicted(boolean onlyPredicted) {
        return new ProteinIndel(onlyPredicted, this.range, this.delSeq, this.insSeq);
    }
}

