/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.protein.change;

import com.google.common.base.Joiner;
import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.protein.ProteinRange;
import de.charite.compbio.jannovar.hgvs.protein.change.ProteinChange;

public class ProteinShortSequenceRepeatVariability
extends ProteinChange {
    private final ProteinRange range;
    private final int minCount;
    private final int maxCount;

    public static ProteinShortSequenceRepeatVariability build(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos, int minCount, int maxCount) {
        return new ProteinShortSequenceRepeatVariability(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), minCount, maxCount);
    }

    public static ProteinShortSequenceRepeatVariability build(boolean onlyPredicted, ProteinRange range, int minCount, int maxCount) {
        return new ProteinShortSequenceRepeatVariability(onlyPredicted, range, minCount, maxCount);
    }

    public ProteinShortSequenceRepeatVariability(boolean onlyPredicted, ProteinRange range, int minCount, int maxCount) {
        super(onlyPredicted);
        this.range = range;
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public ProteinRange getRange() {
        return this.range;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        return this.wrapIfOnlyPredicted(Joiner.on((String)"").join((Object)this.range.toHGVSString(code), (Object)"(", new Object[]{this.minCount, "_", this.maxCount, ")"}));
    }

    public String toString() {
        return "ProteinShortSequenceRepeatVariability [range=" + this.range + ", minCount=" + this.minCount + ", maxCount=" + this.maxCount + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.maxCount;
        result = 31 * result + this.minCount;
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProteinShortSequenceRepeatVariability other = (ProteinShortSequenceRepeatVariability)obj;
        if (this.maxCount != other.maxCount) {
            return false;
        }
        if (this.minCount != other.minCount) {
            return false;
        }
        return !(this.range == null ? other.range != null : !this.range.equals(other.range));
    }

    @Override
    public ProteinChange withOnlyPredicted(boolean onlyPredicted) {
        return new ProteinShortSequenceRepeatVariability(onlyPredicted, this.range, this.minCount, this.maxCount);
    }
}

