/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.protein.change;

import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.protein.ProteinRange;
import de.charite.compbio.jannovar.hgvs.protein.ProteinSeqDescription;
import de.charite.compbio.jannovar.hgvs.protein.change.ProteinChange;

public class ProteinUnchanged
extends ProteinChange {
    private final ProteinRange range;
    private final ProteinSeqDescription seqDesc;

    public static ProteinUnchanged buildWithoutSeqDescription(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos) {
        return new ProteinUnchanged(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos));
    }

    public static ProteinUnchanged buildWithLength(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos, int length) {
        return new ProteinUnchanged(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), length);
    }

    public static ProteinUnchanged buildWithSequence(boolean onlyPredicted, String firstAA, int firstPos, String lastAA, int lastPos, String seq) {
        return new ProteinUnchanged(onlyPredicted, ProteinRange.build(firstAA, firstPos, lastAA, lastPos), seq);
    }

    public ProteinUnchanged(boolean onlyPredicted, ProteinRange range) {
        super(onlyPredicted);
        this.range = range;
        this.seqDesc = new ProteinSeqDescription();
    }

    public ProteinUnchanged(boolean onlyPredicted, ProteinRange range, int length) {
        super(onlyPredicted);
        this.range = range;
        this.seqDesc = new ProteinSeqDescription(length);
    }

    public ProteinUnchanged(boolean onlyPredicted, ProteinRange range, String seq) {
        super(onlyPredicted);
        this.range = range;
        this.seqDesc = new ProteinSeqDescription(seq);
    }

    private ProteinUnchanged(boolean onlyPredicted, ProteinRange range, ProteinSeqDescription seqDesc) {
        super(onlyPredicted);
        this.range = range;
        this.seqDesc = seqDesc;
    }

    public ProteinRange getRange() {
        return this.range;
    }

    public ProteinSeqDescription getSeqDesc() {
        return this.seqDesc;
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        return this.wrapIfOnlyPredicted(this.range.toHGVSString(code) + "=");
    }

    @Override
    public ProteinChange withOnlyPredicted(boolean onlyPredicted) {
        return new ProteinUnchanged(onlyPredicted, this.range, this.seqDesc);
    }
}

