/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.protein.variant;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.ConvertibleToHGVSString;
import de.charite.compbio.jannovar.hgvs.VariantConfiguration;
import de.charite.compbio.jannovar.hgvs.protein.change.ProteinChange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class ProteinChangeAllele
implements ConvertibleToHGVSString,
List<ProteinChange> {
    protected final VariantConfiguration varConfig;
    protected final ImmutableList<ProteinChange> changes;

    public static ProteinChangeAllele singleChangeAllele(ProteinChange change) {
        return new ProteinChangeAllele(VariantConfiguration.IN_CIS, (Collection<? extends ProteinChange>)ImmutableList.of((Object)change));
    }

    public static ProteinChangeAllele build(VariantConfiguration varConfig, ProteinChange ... changes) {
        return new ProteinChangeAllele(varConfig, (Collection<? extends ProteinChange>)ImmutableList.copyOf((Object[])changes));
    }

    public ProteinChangeAllele(VariantConfiguration varConfig, Collection<? extends ProteinChange> changes) {
        this.varConfig = varConfig;
        this.changes = ImmutableList.copyOf(changes);
    }

    public VariantConfiguration getVarConfig() {
        return this.varConfig;
    }

    public ImmutableList<ProteinChange> getChanges() {
        return this.changes;
    }

    @Override
    public String toHGVSString() {
        return this.toHGVSString(AminoAcidCode.THREE_LETTER);
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add("[");
        boolean first = true;
        for (ProteinChange change : this.changes) {
            if (first) {
                first = false;
            } else {
                parts.add(this.varConfig.toHGVSSeparator());
            }
            parts.add(change.toHGVSString(code));
        }
        parts.add("]");
        return Joiner.on((String)"").join(parts);
    }

    public String toString() {
        return "AlleleVariants [varConfig=" + (Object)((Object)this.varConfig) + ", changes=" + this.changes + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.changes == null ? 0 : this.changes.hashCode());
        result = 31 * result + (this.varConfig == null ? 0 : this.varConfig.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProteinChangeAllele other = (ProteinChangeAllele)obj;
        if (this.changes == null ? other.changes != null : !this.changes.equals(other.changes)) {
            return false;
        }
        return this.varConfig == other.varConfig;
    }

    @Override
    public int size() {
        return this.changes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.changes.contains(o);
    }

    @Override
    public Iterator<ProteinChange> iterator() {
        return this.changes.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.changes.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.changes.toArray((Object[])a);
    }

    @Override
    @Deprecated
    public boolean add(ProteinChange e) {
        return this.changes.add((Object)e);
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        return this.changes.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.changes.containsAll(c);
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends ProteinChange> c) {
        return this.changes.addAll(c);
    }

    @Override
    @Deprecated
    public boolean addAll(int index, Collection<? extends ProteinChange> c) {
        return this.changes.addAll(index, c);
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> c) {
        return this.changes.removeAll(c);
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> c) {
        return this.changes.retainAll(c);
    }

    @Override
    @Deprecated
    public void clear() {
        this.changes.clear();
    }

    @Override
    public ProteinChange get(int index) {
        return (ProteinChange)this.changes.get(index);
    }

    @Override
    @Deprecated
    public ProteinChange set(int index, ProteinChange element) {
        return (ProteinChange)this.changes.set(index, (Object)element);
    }

    @Override
    @Deprecated
    public void add(int index, ProteinChange element) {
        this.changes.add(index, (Object)element);
    }

    @Override
    @Deprecated
    public ProteinChange remove(int index) {
        return (ProteinChange)this.changes.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.changes.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.changes.lastIndexOf(o);
    }

    @Override
    public ListIterator<ProteinChange> listIterator() {
        return this.changes.listIterator();
    }

    @Override
    public ListIterator<ProteinChange> listIterator(int index) {
        return this.changes.listIterator(index);
    }

    @Override
    public List<ProteinChange> subList(int fromIndex, int toIndex) {
        return this.changes.subList(fromIndex, toIndex);
    }
}

