/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.protein.variant;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.VariantConfiguration;
import de.charite.compbio.jannovar.hgvs.protein.change.ProteinChange;
import de.charite.compbio.jannovar.hgvs.protein.variant.ProteinChangeAllele;
import de.charite.compbio.jannovar.hgvs.protein.variant.ProteinVariant;
import java.util.ArrayList;
import java.util.Collection;

public class SingleAlleleProteinVariant
extends ProteinVariant {
    protected final ProteinChangeAllele allele;

    public static SingleAlleleProteinVariant makeSingleChangeVariant(String proteinID, ProteinChange change) {
        return new SingleAlleleProteinVariant(proteinID, VariantConfiguration.IN_CIS, (Collection<? extends ProteinChange>)ImmutableList.of((Object)change));
    }

    public static SingleAlleleProteinVariant build(String proteinID, VariantConfiguration varConfig, ProteinChange ... changes) {
        return new SingleAlleleProteinVariant(proteinID, varConfig, (Collection<? extends ProteinChange>)ImmutableList.copyOf((Object[])changes));
    }

    public SingleAlleleProteinVariant(String proteinID, VariantConfiguration varConfig, Collection<? extends ProteinChange> changes) {
        super(proteinID);
        this.allele = new ProteinChangeAllele(varConfig, changes);
    }

    public boolean hasOnlyOneChange() {
        return this.allele.size() == 1;
    }

    public ProteinChange getChange() {
        return this.allele.get(0);
    }

    public ProteinChangeAllele getAllele() {
        return this.allele;
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        if (this.hasOnlyOneChange()) {
            return Joiner.on((String)"").join((Object)this.getSequenceNamePrefix(), (Object)":p.", new Object[]{this.getChange().toHGVSString(code)});
        }
        String sep = this.allele.getVarConfig().toHGVSSeparator();
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.getSequenceNamePrefix());
        parts.add(":p.");
        if (this.hasOnlyOneChange()) {
            parts.add(this.getChange().toHGVSString(code));
        } else {
            parts.add("[");
            boolean first = true;
            for (ProteinChange change : this.allele) {
                if (first) {
                    first = false;
                } else {
                    parts.add(sep);
                }
                parts.add(change.toHGVSString(code));
            }
            parts.add("]");
        }
        return Joiner.on((String)"").join(parts);
    }

    @Override
    public String toString() {
        return "SingleAlleleProteinVariant [allele=" + this.allele + ", toHGVSString()=" + this.toHGVSString() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.allele == null ? 0 : this.allele.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleAlleleProteinVariant other = (SingleAlleleProteinVariant)obj;
        return !(this.allele == null ? other.allele != null : !this.allele.equals(other.allele));
    }
}

