/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.bridge;

import com.google.common.base.Joiner;
import de.charite.compbio.jannovar.annotation.InvalidGenomeVariant;
import de.charite.compbio.jannovar.data.JannovarData;
import de.charite.compbio.jannovar.hgvs.SequenceType;
import de.charite.compbio.jannovar.hgvs.bridge.CannotTranslateHGVSVariant;
import de.charite.compbio.jannovar.hgvs.bridge.NucleotideDeletionToGenomeVariantTranslationImpl;
import de.charite.compbio.jannovar.hgvs.bridge.NucleotideDuplicationToGenomeVariantTranslationImpl;
import de.charite.compbio.jannovar.hgvs.bridge.NucleotideIndelToGenomeVariantTranslationImpl;
import de.charite.compbio.jannovar.hgvs.bridge.NucleotideInsertionToGenomeVariantTranslationImpl;
import de.charite.compbio.jannovar.hgvs.bridge.NucleotideInversionToGenomeVariantTranslationImpl;
import de.charite.compbio.jannovar.hgvs.bridge.NucleotideSubstitutionToGenomeVariantTranslationImpl;
import de.charite.compbio.jannovar.hgvs.bridge.ResultWithWarnings;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideChange;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideDeletion;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideDuplication;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideIndel;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideInsertion;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideInversion;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideSubstitution;
import de.charite.compbio.jannovar.hgvs.nts.variant.SingleAlleleNucleotideVariant;
import de.charite.compbio.jannovar.htsjdk.GenomeRegionSequenceExtractor;
import de.charite.compbio.jannovar.reference.GenomeVariant;
import de.charite.compbio.jannovar.reference.TranscriptModel;
import htsjdk.samtools.reference.IndexedFastaSequenceFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NucleotideChangeToGenomeVariantTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NucleotideChangeToGenomeVariantTranslator.class);
    private final JannovarData jvDB;
    private final GenomeRegionSequenceExtractor seqExtractor;

    public NucleotideChangeToGenomeVariantTranslator(JannovarData jvDB, IndexedFastaSequenceFile indexedFasta) {
        this.jvDB = jvDB;
        this.seqExtractor = new GenomeRegionSequenceExtractor(jvDB, indexedFasta);
    }

    public GenomeVariant translateNucleotideVariantToGenomeVariant(SingleAlleleNucleotideVariant variant) throws CannotTranslateHGVSVariant, InvalidGenomeVariant {
        return this.translateNucleotideVariantToGenomeVariant(variant, true);
    }

    public GenomeVariant translateNucleotideVariantToGenomeVariant(SingleAlleleNucleotideVariant variant, boolean autocorrect) throws CannotTranslateHGVSVariant, InvalidGenomeVariant {
        ResultWithWarnings<GenomeVariant> result;
        if (variant.getSeqType() != SequenceType.CODING_DNA && variant.getSeqType() != SequenceType.NON_CODING_DNA) {
            throw new CannotTranslateHGVSVariant("Currently only coding DNA (\"c.\") and non-coding DNA (\"n.\") coordinates are supported.");
        }
        if (variant.getAllele().size() != 1) {
            throw new CannotTranslateHGVSVariant("Too many alles in variant " + variant.toHGVSString() + ", must be one allele.");
        }
        TranscriptModel tm = (TranscriptModel)this.jvDB.getTmByAccession().get((Object)variant.getRefIDWithVersion());
        if (tm == null) {
            throw new CannotTranslateHGVSVariant("No transcript found for id " + variant.getRefIDWithVersion());
        }
        NucleotideChange ntChange = variant.getAllele().get(0);
        if (ntChange instanceof NucleotideSubstitution) {
            result = new NucleotideSubstitutionToGenomeVariantTranslationImpl(this.seqExtractor).run(tm, variant.getSeqType(), (NucleotideSubstitution)ntChange);
        } else if (ntChange instanceof NucleotideDeletion) {
            result = new NucleotideDeletionToGenomeVariantTranslationImpl(this.seqExtractor).run(tm, variant.getSeqType(), (NucleotideDeletion)ntChange);
        } else if (ntChange instanceof NucleotideDuplication) {
            result = new NucleotideDuplicationToGenomeVariantTranslationImpl(this.seqExtractor).run(tm, variant.getSeqType(), (NucleotideDuplication)ntChange);
        } else if (ntChange instanceof NucleotideIndel) {
            result = new NucleotideIndelToGenomeVariantTranslationImpl(this.seqExtractor).run(tm, variant.getSeqType(), (NucleotideIndel)ntChange);
        } else if (ntChange instanceof NucleotideInsertion) {
            result = new NucleotideInsertionToGenomeVariantTranslationImpl(this.seqExtractor).run(tm, variant.getSeqType(), (NucleotideInsertion)ntChange);
        } else if (ntChange instanceof NucleotideInversion) {
            result = new NucleotideInversionToGenomeVariantTranslationImpl(this.seqExtractor).run(tm, variant.getSeqType(), (NucleotideInversion)ntChange);
        } else {
            throw new CannotTranslateHGVSVariant("Currently unsupported HGVS variant type in " + ntChange.toHGVSString());
        }
        if (!result.getWarnings().isEmpty() && !autocorrect) {
            throw new CannotTranslateHGVSVariant("Had to auto-correct variant in translation: " + Joiner.on((String)"; ").join(result.getWarnings()));
        }
        for (String msg : result.getWarnings()) {
            LOGGER.warn(msg);
        }
        return result.getValue();
    }
}

