/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.bridge;

import de.charite.compbio.jannovar.annotation.InvalidGenomeVariant;
import de.charite.compbio.jannovar.hgvs.SequenceType;
import de.charite.compbio.jannovar.hgvs.bridge.CannotTranslateHGVSVariant;
import de.charite.compbio.jannovar.hgvs.bridge.NucleotideChangeToGenomeVariantTranslationImplBase;
import de.charite.compbio.jannovar.hgvs.bridge.ResultWithWarnings;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideRange;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideSeqDescription;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideIndel;
import de.charite.compbio.jannovar.htsjdk.GenomeRegionSequenceExtractor;
import de.charite.compbio.jannovar.reference.GenomeInterval;
import de.charite.compbio.jannovar.reference.GenomeVariant;
import de.charite.compbio.jannovar.reference.Strand;
import de.charite.compbio.jannovar.reference.TranscriptModel;

class NucleotideIndelToGenomeVariantTranslationImpl
extends NucleotideChangeToGenomeVariantTranslationImplBase {
    public NucleotideIndelToGenomeVariantTranslationImpl(GenomeRegionSequenceExtractor seqExtractor) {
        super(seqExtractor);
    }

    public ResultWithWarnings<GenomeVariant> run(TranscriptModel tm, SequenceType sequenceType, NucleotideIndel ntIndel) throws CannotTranslateHGVSVariant, InvalidGenomeVariant {
        NucleotideRange range = ntIndel.getRange();
        NucleotideSeqDescription insertedNTDesc = ntIndel.getInsSeq();
        NucleotideSeqDescription deletedNTDesc = ntIndel.getDelSeq();
        GenomeInterval gItv = this.posConverter.translateNucleotideRange(tm, range, sequenceType);
        if (insertedNTDesc.getNucleotides() == null) {
            throw new CannotTranslateHGVSVariant("Nucleotides must be given but were not in " + ntIndel.toHGVSString());
        }
        String warningMsg = null;
        String deletedNTs = deletedNTDesc.getNucleotides();
        if (deletedNTs == null) {
            deletedNTs = this.getGenomeSeq(tm.getStrand(), gItv);
            if (deletedNTDesc.length() != -1 && deletedNTDesc.length() != deletedNTs.length()) {
                warningMsg = "Invalid reference nucleotide count in " + ntIndel.toHGVSString() + ", expected " + deletedNTs.length();
            }
        } else {
            String refSeq = this.getGenomeSeq(tm.getStrand(), gItv);
            if (!refSeq.equals(deletedNTs)) {
                warningMsg = "Invalid reference nucleotides in " + ntIndel.toHGVSString() + ", expected " + refSeq;
            }
            deletedNTs = refSeq;
        }
        GenomeVariant result = new GenomeVariant(gItv.withStrand(tm.getStrand()).getGenomeBeginPos(), deletedNTs, insertedNTDesc.getNucleotides(), tm.getStrand()).withStrand(Strand.FWD);
        if (warningMsg != null) {
            return ResultWithWarnings.construct(result, warningMsg);
        }
        return ResultWithWarnings.construct(result);
    }
}

