/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.bridge;

import de.charite.compbio.jannovar.annotation.InvalidGenomeVariant;
import de.charite.compbio.jannovar.hgvs.SequenceType;
import de.charite.compbio.jannovar.hgvs.bridge.CannotTranslateHGVSVariant;
import de.charite.compbio.jannovar.hgvs.bridge.NucleotideChangeToGenomeVariantTranslationImplBase;
import de.charite.compbio.jannovar.hgvs.bridge.ResultWithWarnings;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideRange;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideSeqDescription;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideInsertion;
import de.charite.compbio.jannovar.htsjdk.GenomeRegionSequenceExtractor;
import de.charite.compbio.jannovar.reference.GenomeInterval;
import de.charite.compbio.jannovar.reference.GenomeVariant;
import de.charite.compbio.jannovar.reference.Strand;
import de.charite.compbio.jannovar.reference.TranscriptModel;

class NucleotideInsertionToGenomeVariantTranslationImpl
extends NucleotideChangeToGenomeVariantTranslationImplBase {
    public NucleotideInsertionToGenomeVariantTranslationImpl(GenomeRegionSequenceExtractor seqExtractor) {
        super(seqExtractor);
    }

    public ResultWithWarnings<GenomeVariant> run(TranscriptModel tm, SequenceType sequenceType, NucleotideInsertion ntIns) throws CannotTranslateHGVSVariant, InvalidGenomeVariant {
        NucleotideRange range = ntIns.getRange();
        NucleotideSeqDescription insertedNTDesc = ntIns.getSeq();
        GenomeInterval gItv = this.posConverter.translateNucleotideRange(tm, range, sequenceType);
        if (insertedNTDesc.getNucleotides() == null) {
            throw new CannotTranslateHGVSVariant("Nucleotides must be given but were not in " + ntIns.toHGVSString());
        }
        GenomeVariant result = new GenomeVariant(gItv.withStrand(tm.getStrand()).getGenomeBeginPos().shifted(1), "", insertedNTDesc.getNucleotides(), tm.getStrand()).withStrand(Strand.FWD);
        return ResultWithWarnings.construct(result);
    }
}

