/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.mendel.bridge;

import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;

public class MendelVCFHeaderExtender {
    public static String AD = "AD";
    public static String AR = "AR";
    public static String XD = "XD";
    public static String XR = "XR";
    public static final String MT = "MT";
    public static String AR_HOM_ALT = "AR_HOM_ALT";
    public static String AR_COMP_HET = "AR_COMP_HET";
    public static String XR_HOM_ALT = "XR_HOM_ALT";
    public static String XR_COMP_HET = "XR_COMP_HET";

    public void extendHeader(VCFHeader vcfHeader) {
        this.extendHeader(vcfHeader, "");
    }

    public static String key() {
        return MendelVCFHeaderExtender.key("");
    }

    public static String key(String prefix) {
        return prefix + "INHERITANCE";
    }

    public static String keySub() {
        return MendelVCFHeaderExtender.keySub("");
    }

    public static String keySub(String prefix) {
        return prefix + "INHERITANCE_RECESSIVE_DETAIL";
    }

    public void extendHeader(VCFHeader vcfHeader, String prefix) {
        VCFInfoHeaderLine inheritanceLine = new VCFInfoHeaderLine(MendelVCFHeaderExtender.key(prefix), VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Compatible inheritance modes (AD, AR, XD, XR, MT)");
        vcfHeader.addMetaDataLine((VCFHeaderLine)inheritanceLine);
        VCFInfoHeaderLine subInheritanceLine = new VCFInfoHeaderLine(MendelVCFHeaderExtender.keySub(prefix), VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Extra annotation for recessive inheritance sub type (AR_HOM_ALT, AR_COMP_HET, XR_HOM_ALT, XR_COMP_HET)");
        vcfHeader.addMetaDataLine((VCFHeaderLine)subInheritanceLine);
    }
}

