/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.mendel.bridge;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.charite.compbio.jannovar.annotation.VariantEffect;
import de.charite.compbio.jannovar.mendel.ChromosomeType;
import de.charite.compbio.jannovar.mendel.GenotypeBuilder;
import de.charite.compbio.jannovar.mendel.GenotypeCalls;
import de.charite.compbio.jannovar.mendel.GenotypeCallsBuilder;
import de.charite.compbio.jannovar.mendel.IncompatiblePedigreeException;
import de.charite.compbio.jannovar.mendel.MendelianInheritanceChecker;
import de.charite.compbio.jannovar.mendel.ModeOfInheritance;
import de.charite.compbio.jannovar.mendel.SubModeOfInheritance;
import de.charite.compbio.jannovar.mendel.bridge.CannotAnnotateMendelianInheritance;
import de.charite.compbio.jannovar.mendel.bridge.MendelVCFHeaderExtender;
import de.charite.compbio.jannovar.pedigree.Pedigree;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class VariantContextMendelianAnnotator {
    private static final ImmutableSet<String> VAR_FILTERS = ImmutableSet.of((Object)"AllAffGtFiltered", (Object)"MaxFreqAd", (Object)"MaxFreqAr", (Object)"OffExome");
    private static final ImmutableSet<String> VAR_FILTERS_AD = ImmutableSet.of((Object)"MaxFreqAd");
    private static final ImmutableSet<String> VAR_FILTERS_AR = ImmutableSet.of((Object)"MaxFreqAr");
    private static final ImmutableSet<String> GT_FILTERS = ImmutableSet.of((Object)"MaxCov", (Object)"MinGq");
    private static final ImmutableSet<String> GT_FILTERS_HOM_REF = ImmutableSet.of((Object)"MinAafHomRef");
    private static final ImmutableSet<String> GT_FILTERS_HOM_ALT = ImmutableSet.of((Object)"MinCovHomAlt", (Object)"MinAafHomAlt");
    private static final ImmutableSet<String> GT_FILTERS_HET = ImmutableSet.of((Object)"MinCovHet", (Object)"MinAafHet", (Object)"MaxAafHet");
    private final Pedigree pedigree;
    private final MendelianInheritanceChecker mendelChecker;
    boolean interpretGenotypeFilters;
    boolean interpretVariantFilters;

    public VariantContextMendelianAnnotator(Pedigree pedigree, boolean interpretGenotypeFilters, boolean interpretVariantFilters) {
        this.pedigree = pedigree;
        this.mendelChecker = new MendelianInheritanceChecker(this.pedigree);
        this.interpretGenotypeFilters = interpretGenotypeFilters;
        this.interpretVariantFilters = interpretVariantFilters;
    }

    public VariantContext annotateRecord(VariantContext vc) throws CannotAnnotateMendelianInheritance {
        return (VariantContext)this.annotateRecords((List<VariantContext>)ImmutableList.of((Object)vc)).get(0);
    }

    public ImmutableList<VariantContext> annotateRecords(List<VariantContext> vcs) throws CannotAnnotateMendelianInheritance {
        HashMap<Integer, Integer> identityToIndex = new HashMap<Integer, Integer>();
        for (int i = 0; i < vcs.size(); ++i) {
            identityToIndex.put(System.identityHashCode(vcs.get(i)), i);
        }
        ImmutableMap<SubModeOfInheritance, ImmutableList<VariantContext>> compatibleSubModes = this.computeCompatibleInheritanceSubModes(vcs);
        HashMap map = new HashMap();
        HashMap subMap = new HashMap();
        for (Map.Entry e : compatibleSubModes.entrySet()) {
            SubModeOfInheritance subMode = (SubModeOfInheritance)e.getKey();
            for (VariantContext vc : (ImmutableList)e.getValue()) {
                int key = (Integer)identityToIndex.get(System.identityHashCode(vc));
                map.putIfAbsent(key, new TreeSet());
                subMap.putIfAbsent(key, new TreeSet());
                switch (subMode) {
                    case AUTOSOMAL_DOMINANT: {
                        ((Set)map.get(key)).add("AD");
                        break;
                    }
                    case AUTOSOMAL_RECESSIVE_COMP_HET: {
                        ((Set)subMap.get(key)).add(MendelVCFHeaderExtender.AR_COMP_HET);
                    }
                    case AUTOSOMAL_RECESSIVE_HOM_ALT: {
                        ((Set)subMap.get(key)).add(MendelVCFHeaderExtender.AR_HOM_ALT);
                        ((Set)map.get(key)).add("AR");
                        break;
                    }
                    case X_DOMINANT: {
                        ((Set)map.get(key)).add("XD");
                        break;
                    }
                    case X_RECESSIVE_COMP_HET: {
                        ((Set)subMap.get(key)).add(MendelVCFHeaderExtender.XR_COMP_HET);
                    }
                    case X_RECESSIVE_HOM_ALT: {
                        ((Set)subMap.get(key)).add(MendelVCFHeaderExtender.XR_HOM_ALT);
                        ((Set)map.get(key)).add("XR");
                        break;
                    }
                    case MITOCHONDRIAL: {
                        ((Set)subMap.get(key)).add("MT");
                        ((Set)map.get(key)).add("MT");
                    }
                }
            }
        }
        ArrayList<VariantContextBuilder> vcBuilders = new ArrayList<VariantContextBuilder>();
        for (int i = 0; i < vcs.size(); ++i) {
            vcBuilders.add(new VariantContextBuilder(vcs.get(i)));
        }
        for (Map.Entry e : map.entrySet()) {
            VariantContextBuilder vcBuilder = (VariantContextBuilder)vcBuilders.get((Integer)e.getKey());
            vcBuilder.attribute(MendelVCFHeaderExtender.key(), e.getValue());
            vcBuilder.attribute(MendelVCFHeaderExtender.keySub(), subMap.get(e.getKey()));
        }
        ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
        for (int i = 0; i < vcs.size(); ++i) {
            resultBuilder.add((Object)((VariantContextBuilder)vcBuilders.get(i)).make());
        }
        return resultBuilder.build();
    }

    public ImmutableMap<ModeOfInheritance, ImmutableList<VariantContext>> computeCompatibleInheritanceModes(List<VariantContext> vcs) throws CannotAnnotateMendelianInheritance {
        ImmutableMap checkResult;
        List<GenotypeCalls> gcs = this.buildGenotypeCalls(vcs);
        List<GenotypeCalls> recessiveGCs = this.buildRecessiveGenotypeCalls(vcs);
        try {
            checkResult = this.mendelChecker.checkMendelianInheritance(gcs, recessiveGCs);
        }
        catch (IncompatiblePedigreeException e) {
            throw new CannotAnnotateMendelianInheritance("Problem with annotating VariantContext for Mendelian inheritance.", e);
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry e : checkResult.entrySet()) {
            ImmutableList.Builder listBuilder = new ImmutableList.Builder();
            for (GenotypeCalls gc : (ImmutableList)e.getValue()) {
                listBuilder.add((Object)vcs.get((Integer)gc.getPayload()));
            }
            builder.put(e.getKey(), (Object)listBuilder.build());
        }
        return builder.build();
    }

    public ImmutableMap<SubModeOfInheritance, ImmutableList<VariantContext>> computeCompatibleInheritanceSubModes(List<VariantContext> vcs) throws CannotAnnotateMendelianInheritance {
        ImmutableMap checkResult;
        List<GenotypeCalls> gcs = this.buildGenotypeCalls(vcs);
        List<GenotypeCalls> recessiveGCs = this.buildRecessiveGenotypeCalls(vcs);
        try {
            checkResult = this.mendelChecker.checkMendelianInheritanceSub(gcs, recessiveGCs);
        }
        catch (IncompatiblePedigreeException e) {
            throw new CannotAnnotateMendelianInheritance("Problem with annotating VariantContext for Mendelian inheritance.", e);
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry e : checkResult.entrySet()) {
            ImmutableList.Builder listBuilder = new ImmutableList.Builder();
            for (GenotypeCalls gc : (ImmutableList)e.getValue()) {
                listBuilder.add((Object)vcs.get((Integer)gc.getPayload()));
            }
            builder.put(e.getKey(), (Object)listBuilder.build());
        }
        return builder.build();
    }

    private List<GenotypeCalls> buildGenotypeCalls(Collection<VariantContext> vcs) {
        ArrayList<GenotypeCalls> result = new ArrayList<GenotypeCalls>();
        ImmutableList xNames = ImmutableList.of((Object)"x", (Object)"X", (Object)"23", (Object)"chrx", (Object)"chrX", (Object)"chr23");
        ImmutableList mtNames = ImmutableList.of((Object)"m", (Object)"M", (Object)"mt", (Object)"MT", (Object)"chrm", (Object)"chrM", (Object)"chrmt", (Object)"chrMT");
        int i = 0;
        for (VariantContext vc : vcs) {
            GenotypeCallsBuilder builder = new GenotypeCallsBuilder();
            builder.setPayload((Object)i++);
            if (xNames.contains((Object)vc.getContig())) {
                builder.setChromType(ChromosomeType.X_CHROMOSOMAL);
            } else if (mtNames.contains((Object)vc.getContig())) {
                builder.setChromType(ChromosomeType.MITOCHONDRIAL);
            } else {
                builder.setChromType(ChromosomeType.AUTOSOMAL);
            }
            for (Genotype gt : vc.getGenotypes()) {
                ArrayList<String> gtFilters = new ArrayList<String>();
                if (gt.getFilters() != null) {
                    gtFilters.addAll(Arrays.asList(gt.getFilters().split(";")));
                }
                boolean isFiltered = false;
                if (gt.isHet()) {
                    if (this.interpretGenotypeFilters && this.isFiltered((Collection<String>)gtFilters, (Collection<String>)GT_FILTERS, (Collection<String>)GT_FILTERS_HET)) {
                        isFiltered = true;
                    }
                } else if (gt.isHomRef()) {
                    if (this.interpretGenotypeFilters && this.isFiltered((Collection<String>)gtFilters, (Collection<String>)GT_FILTERS, (Collection<String>)GT_FILTERS_HOM_REF)) {
                        isFiltered = true;
                    }
                } else if (this.interpretGenotypeFilters && this.isFiltered((Collection<String>)gtFilters, (Collection<String>)GT_FILTERS, (Collection<String>)GT_FILTERS_HOM_ALT)) {
                    isFiltered = true;
                }
                GenotypeBuilder gtBuilder = new GenotypeBuilder();
                for (Allele allele : gt.getAlleles()) {
                    if (isFiltered) {
                        gtBuilder.getAlleleNumbers().add(-1);
                        continue;
                    }
                    int aIDX = vc.getAlleleIndex(allele);
                    gtBuilder.getAlleleNumbers().add(aIDX);
                }
                builder.getSampleToGenotype().put(gt.getSampleName(), gtBuilder.build());
            }
            result.add(builder.build());
        }
        return result;
    }

    List<GenotypeCalls> buildRecessiveGenotypeCalls(List<VariantContext> vcs) {
        String synonymous = VariantEffect.SYNONYMOUS_VARIANT.getSequenceOntologyTerm();
        Predicate<VariantContext> keepFreqRecessive = this.interpretVariantFilters ? vc -> !this.isFiltered(vc.getFilters(), (Collection<String>)VAR_FILTERS, (Collection<String>)VAR_FILTERS_AR) && !vc.getAttributeAsString("ANN", "").contains(synonymous) : vc -> true;
        return this.buildGenotypeCalls(vcs.stream().filter(keepFreqRecessive).collect(Collectors.toList()));
    }

    private boolean isFiltered(Collection<String> vcFilters, Collection<String> filtersA, Collection<String> filtersB) {
        HashSet<String> filterIntersection = new HashSet<String>(filtersA);
        filterIntersection.addAll(filtersB);
        filterIntersection.retainAll(vcFilters);
        return !filterIntersection.isEmpty();
    }
}

