/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.mendel.filter;

import de.charite.compbio.jannovar.mendel.filter.VariantContextFilterException;
import de.charite.compbio.jannovar.mendel.filter.VariantContextProcessor;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.HashSet;

public class CoordinateSortingChecker
implements VariantContextProcessor {
    VariantContextProcessor sink;
    private final HashSet<String> seenChromosomes = new HashSet();
    private VariantContext prevVC = null;

    public CoordinateSortingChecker(VariantContextProcessor sink) {
        this.sink = sink;
    }

    @Override
    public void put(VariantContext vc) throws VariantContextFilterException {
        if (this.prevVC != null) {
            if (!vc.getContig().equals(this.prevVC.getContig())) {
                if (this.seenChromosomes.contains(vc.getContig())) {
                    throw new VariantContextFilterException("Unsorted VCF file, seen " + vc.getContig() + " twice!");
                }
            } else if (vc.getStart() < this.prevVC.getStart()) {
                throw new VariantContextFilterException("Unsorted VCF file, seen " + vc.getStart() + " < " + this.prevVC.getStart());
            }
        }
        this.sink.put(vc);
        this.prevVC = vc;
    }

    @Override
    public void close() {
        this.sink.close();
    }
}

