/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.mendel.filter;

import com.google.common.collect.ImmutableList;
import de.charite.compbio.jannovar.data.ReferenceDictionary;
import de.charite.compbio.jannovar.reference.GenomeInterval;
import de.charite.compbio.jannovar.reference.Strand;
import de.charite.compbio.jannovar.reference.TranscriptModel;

class Gene {
    private final String name;
    private final ImmutableList<TranscriptModel> transcripts;
    private final ReferenceDictionary refDict;
    private final GenomeInterval region;

    public Gene(ReferenceDictionary refDict, String name, ImmutableList<TranscriptModel> transcripts) {
        this.refDict = refDict;
        this.name = name;
        this.transcripts = transcripts;
        this.region = this.buildGeneRegion();
    }

    public String getName() {
        return this.name;
    }

    public ImmutableList<TranscriptModel> getTranscripts() {
        return this.transcripts;
    }

    public ReferenceDictionary getRefDict() {
        return this.refDict;
    }

    public GenomeInterval getRegion() {
        return this.region;
    }

    private GenomeInterval buildGeneRegion() {
        if (this.transcripts.isEmpty()) {
            return null;
        }
        GenomeInterval region = ((TranscriptModel)this.transcripts.get(0)).getTXRegion().withStrand(Strand.FWD);
        for (TranscriptModel tm : this.transcripts) {
            region = this.mergeRegions(region, tm.getTXRegion());
        }
        return region;
    }

    private GenomeInterval mergeRegions(GenomeInterval lhs, GenomeInterval rhs) {
        lhs = lhs.withStrand(Strand.FWD);
        rhs = rhs.withStrand(Strand.FWD);
        return new GenomeInterval(lhs.getGenomeBeginPos().getRefDict(), Strand.FWD, lhs.getGenomeBeginPos().getChr(), Math.min(lhs.getBeginPos(), rhs.getBeginPos()), Math.max(lhs.getEndPos(), rhs.getEndPos()));
    }

    public String toString() {
        return this.name + "(" + this.region + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Gene other = (Gene)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

