/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.mendel.filter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.charite.compbio.jannovar.UncheckedJannovarException;
import de.charite.compbio.jannovar.data.Chromosome;
import de.charite.compbio.jannovar.data.JannovarData;
import de.charite.compbio.jannovar.data.ReferenceDictionary;
import de.charite.compbio.jannovar.impl.intervals.Interval;
import de.charite.compbio.jannovar.impl.intervals.IntervalArray;
import de.charite.compbio.jannovar.mendel.IncompatiblePedigreeException;
import de.charite.compbio.jannovar.mendel.SubModeOfInheritance;
import de.charite.compbio.jannovar.mendel.bridge.CannotAnnotateMendelianInheritance;
import de.charite.compbio.jannovar.mendel.bridge.MendelVCFHeaderExtender;
import de.charite.compbio.jannovar.mendel.bridge.VariantContextMendelianAnnotator;
import de.charite.compbio.jannovar.mendel.filter.Gene;
import de.charite.compbio.jannovar.mendel.filter.GeneBuilder;
import de.charite.compbio.jannovar.mendel.filter.GeneList;
import de.charite.compbio.jannovar.mendel.filter.VariantContextCounter;
import de.charite.compbio.jannovar.mendel.filter.VariantContextFilterException;
import de.charite.compbio.jannovar.mendel.filter.VariantContextProcessor;
import de.charite.compbio.jannovar.pedigree.Pedigree;
import de.charite.compbio.jannovar.reference.GenomeInterval;
import de.charite.compbio.jannovar.reference.Strand;
import de.charite.compbio.jannovar.reference.TranscriptModel;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFHeader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneWiseMendelianAnnotationProcessor
implements VariantContextProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneWiseMendelianAnnotationProcessor.class);
    private final Pedigree pedigree;
    private final VariantContextMendelianAnnotator annotator;
    private JannovarData jannovarData;
    private final Consumer<VariantContext> sink;
    private final ContigInfoProvider contigInfoProvider;
    private final boolean interpretGenotypeFilters;
    private final boolean interpretVariantFilters;
    HashMap<Gene, ArrayList<VariantContext>> activeGenes = new HashMap();
    HashMap<VariantContext, VariantContextCounter> activeVariants = new HashMap();
    private final GeneList geneList;

    public GeneWiseMendelianAnnotationProcessor(Pedigree pedigree, JannovarData jannovarData, Consumer<VariantContext> sink, boolean interpretFilters) {
        this.pedigree = pedigree;
        this.jannovarData = jannovarData;
        this.sink = sink;
        this.interpretGenotypeFilters = interpretFilters;
        this.interpretVariantFilters = interpretFilters;
        this.geneList = GeneWiseMendelianAnnotationProcessor.buildGeneList(this.jannovarData);
        this.annotator = new VariantContextMendelianAnnotator(this.pedigree, this.interpretGenotypeFilters, this.interpretVariantFilters);
        this.contigInfoProvider = new ContigInfoProvider();
    }

    @Override
    public void put(VariantContext vc) throws VariantContextFilterException {
        LOGGER.trace("Putting variant {} into inheritance filter", new Object[]{vc});
        if (this.contigInfoProvider.getCurrentContig() == null || !this.contigInfoProvider.getCurrentContig().equals(vc.getContig())) {
            this.contigInfoProvider.registerContig(vc.getContig());
        } else if (!this.contigInfoProvider.isContigKnown(vc.getContig())) {
            throw new UncheckedJannovarException("Variants are not sorted by chromosome, seeing contig " + vc.getContig() + " the second time with contig " + this.contigInfoProvider.getCurrentContig() + " before the second time");
        }
        ReferenceDictionary refDict = this.jannovarData.getRefDict();
        Optional<Object> contigID = Optional.ofNullable(refDict.getContigNameToID().get((Object)vc.getContig()));
        Optional<IntervalArray> iTree = contigID.map(x -> (IntervalArray)this.geneList.getGeneIntervalTree().get(x));
        if (!iTree.isPresent()) {
            LOGGER.trace("Unknown contig or contig without annotation in " + vc.getContig() + ", flushing current contig and writing out.");
            this.markDoneGenes(-1, -1);
            this.sink.accept(vc);
            return;
        }
        Optional<GenomeInterval> changeInterval = contigID.map(x -> new GenomeInterval(refDict, Strand.FWD, x.intValue(), vc.getStart() - 1, vc.getEnd()));
        Optional<Object> qr = Optional.empty();
        if (changeInterval.isPresent()) {
            qr = changeInterval.get().length() == 0 ? iTree.map(x -> x.findOverlappingWithPoint(((GenomeInterval)changeInterval.get()).getBeginPos())) : iTree.map(x -> x.findOverlappingWithInterval(((GenomeInterval)changeInterval.get()).getBeginPos(), ((GenomeInterval)changeInterval.get()).getEndPos()));
        }
        if (qr.isPresent()) {
            if (((IntervalArray.QueryResult)qr.get()).getEntries().isEmpty()) {
                this.putVariantForGene(vc, null);
            } else {
                for (Gene gene : ((IntervalArray.QueryResult)qr.get()).getEntries()) {
                    if (!this.isGeneAffectedByChange(gene, vc)) continue;
                    this.putVariantForGene(vc, gene);
                }
            }
        }
        if (contigID.isPresent()) {
            this.markDoneGenes((Integer)contigID.get(), vc.getStart() - 1);
        } else {
            this.markDoneGenes(-1, -1);
        }
    }

    private boolean isGeneAffectedByChange(Gene gene, VariantContext vc) {
        int contigID;
        ReferenceDictionary refDict = this.jannovarData.getRefDict();
        GenomeInterval changeInterval = new GenomeInterval(refDict, Strand.FWD, contigID = ((Integer)refDict.getContigNameToID().get((Object)vc.getContig())).intValue(), vc.getStart() - 1, vc.getEnd());
        if (changeInterval.length() == 0 && gene.getRegion().contains(changeInterval.getGenomeBeginPos()) && gene.getRegion().contains(changeInterval.getGenomeBeginPos().shifted(-1))) {
            return false;
        }
        return changeInterval.length() != 0 && gene.getRegion().overlapsWith(changeInterval);
    }

    @Override
    public void close() {
        LOGGER.trace("Closing mendelian annotation processor");
        this.markDoneGenes(-1, -1);
        if (!this.activeVariants.isEmpty()) {
            throw new VariantContextFilterException("All variants should be inactive now");
        }
        if (!this.activeGenes.isEmpty()) {
            throw new VariantContextFilterException("All genes should be inactive now");
        }
    }

    public void extendHeader(VCFHeader vcfHeader, String prefix) {
        new MendelVCFHeaderExtender().extendHeader(vcfHeader, prefix);
    }

    private static GeneList buildGeneList(JannovarData jannovarDB) {
        HashMap<String, GeneBuilder> geneMap = new HashMap<String, GeneBuilder>();
        for (Chromosome chrom : jannovarDB.getChromosomes().values()) {
            for (Interval itv : chrom.getTMIntervalTree().getIntervals()) {
                TranscriptModel tm = (TranscriptModel)itv.getValue();
                if (!geneMap.containsKey(tm.getGeneSymbol())) {
                    geneMap.put(tm.getGeneSymbol(), new GeneBuilder(jannovarDB.getRefDict(), tm.getGeneSymbol()));
                }
                ((GeneBuilder)geneMap.get(tm.getGeneSymbol())).addTranscriptModel(tm);
            }
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (GeneBuilder gene : geneMap.values()) {
            builder.add((Object)gene.build());
        }
        return new GeneList((ImmutableList<Gene>)builder.build());
    }

    private void putVariantForGene(VariantContext vc, Gene gene) {
        LOGGER.trace("Assigning variant {} to gene {}", new Object[]{vc, gene});
        this.activeVariants.computeIfAbsent(vc, x -> new VariantContextCounter((VariantContext)x, 0));
        if (gene == null) {
            try {
                this.annotator.annotateRecord(vc);
            }
            catch (CannotAnnotateMendelianInheritance e) {
                throw new UncheckedJannovarException("Problem with mendelian variant annotation in variant context", (Throwable)((Object)e));
            }
            return;
        }
        this.activeVariants.get(vc).increment();
        this.activeGenes.computeIfAbsent(gene, x -> new ArrayList());
        this.activeGenes.get(gene).add(vc);
    }

    private void markDoneGenes(int contigID, int pos) throws VariantContextFilterException {
        ArrayList<Gene> doneGenes = new ArrayList<Gene>();
        for (Map.Entry<Gene, ArrayList<VariantContext>> entry : this.activeGenes.entrySet()) {
            Gene gene = entry.getKey();
            if (gene.getRegion().getChr() != contigID) {
                doneGenes.add(gene);
                continue;
            }
            if (gene.getRegion().getEndPos() > pos) continue;
            doneGenes.add(gene);
        }
        if (doneGenes.isEmpty()) {
            this.processedGene(null);
        } else {
            for (Gene gene : doneGenes) {
                this.processedGene(gene);
                this.activeGenes.remove(gene);
            }
        }
        if (!doneGenes.isEmpty() && this.activeGenes.isEmpty() && !this.activeVariants.isEmpty()) {
            throw new RuntimeException("All genes inactive, there should be no active variant");
        }
    }

    private void checkVariantsForGene(Gene gene) throws VariantContextFilterException, CannotAnnotateMendelianInheritance {
        ArrayList<VariantContext> variantsForGene = this.activeGenes.get(gene);
        ImmutableMap<SubModeOfInheritance, ImmutableList<VariantContext>> compatibleMap = this.annotator.computeCompatibleInheritanceSubModes(variantsForGene);
        for (Map.Entry e : compatibleMap.entrySet()) {
            for (VariantContext vc : (ImmutableList)e.getValue()) {
                this.activeVariants.get(vc).addCompatibleMode((SubModeOfInheritance)e.getKey());
            }
        }
    }

    private void processedGene(Gene gene) throws VariantContextFilterException {
        try {
            if (gene != null) {
                this.checkVariantsForGene(gene);
            }
        }
        catch (CannotAnnotateMendelianInheritance e) {
            if (e.getCause().getClass().equals(IncompatiblePedigreeException.class)) {
                throw new VariantContextFilterException("Cannot annotate Mendelian inheritance, pedigree is incompatible to genotypes", (Throwable)((Object)e));
            }
            throw new VariantContextFilterException("Problem with annotating variant for Mendelian inheritance", (Throwable)((Object)e));
        }
        if (gene != null) {
            LOGGER.trace("Gene done {}", new Object[]{gene.getName()});
        } else {
            LOGGER.trace("Marking variants as done without any gene");
        }
        for (VariantContextCounter var : this.activeVariants.values()) {
            if (gene == null || !this.isGeneAffectedByChange(gene, var.getVariantContext())) continue;
            LOGGER.trace("Gene {} done for variant {}", new Object[]{gene.getName(), var.getVariantContext().getContig() + ":" + var.getVariantContext().getStart()});
            var.decrement();
        }
        Comparator<VariantContextCounter> cmp = new Comparator<VariantContextCounter>(){

            @Override
            public int compare(VariantContextCounter lhs, VariantContextCounter rhs) {
                int idxRhs;
                int idxLhs = GeneWiseMendelianAnnotationProcessor.this.contigInfoProvider.getContigNoForName(lhs.getVariantContext().getContig());
                if (idxLhs != (idxRhs = GeneWiseMendelianAnnotationProcessor.this.contigInfoProvider.getContigNoForName(rhs.getVariantContext().getContig()))) {
                    return idxLhs - idxRhs;
                }
                return lhs.getVariantContext().getStart() - rhs.getVariantContext().getStart();
            }
        };
        Optional<VariantContextCounter> leftmost = this.activeVariants.values().stream().filter(x -> x.getCounter() != 0).min(cmp);
        List done = this.activeVariants.values().stream().filter(x -> !leftmost.isPresent() || cmp.compare((VariantContextCounter)x, (VariantContextCounter)leftmost.get()) < 0).collect(Collectors.toList());
        Collections.sort(done, cmp);
        for (VariantContextCounter var : done) {
            this.activeVariants.remove(var.getVariantContext());
            ArrayList modes = new ArrayList();
            modes.addAll(var.getCompatibleModes().stream().map(m -> m.toModeOfInheritance().getAbbreviation()).filter(m -> m != null).collect(Collectors.toList()));
            ArrayList arSubModes = new ArrayList();
            arSubModes.addAll(var.getCompatibleModes().stream().filter(m -> m.isRecessive()).map(m -> m.getAbbreviation()).filter(m -> m != null).collect(Collectors.toList()));
            if (modes.isEmpty()) {
                this.sink.accept(var.getVariantContext());
                continue;
            }
            VariantContextBuilder vcBuilder = new VariantContextBuilder(var.getVariantContext());
            if (!modes.isEmpty()) {
                vcBuilder.attribute(MendelVCFHeaderExtender.key(), modes);
            }
            if (!arSubModes.isEmpty()) {
                vcBuilder.attribute(MendelVCFHeaderExtender.keySub(), arSubModes);
            }
            this.sink.accept(vcBuilder.make());
        }
        if (gene != null) {
            LOGGER.trace("Gene {} is inactive now", new Object[]{gene.getName()});
            this.activeGenes.remove(gene);
        }
    }

    private class ContigInfoProvider {
        private static final int UNKNOWN = -1;
        private String currentContig = null;
        private int nextContigNo = 0;
        private Map<String, Integer> contigNameToNo = new HashMap<String, Integer>();

        private ContigInfoProvider() {
        }

        int getContigNoForName(String name) {
            if (this.contigNameToNo.containsKey(name)) {
                return this.contigNameToNo.get(name);
            }
            return -1;
        }

        boolean isContigKnown(String name) {
            return this.getContigNoForName(name) != -1;
        }

        int registerContig(String name) {
            if (this.isContigKnown(name)) {
                throw new RuntimeException("Seeing contig " + name + " a second time (with other contig name in between). Is your file sorted?");
            }
            this.contigNameToNo.put(name, this.nextContigNo);
            this.currentContig = name;
            return this.nextContigNo++;
        }

        String getCurrentContig() {
            return this.currentContig;
        }
    }
}

