/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.progress;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.charite.compbio.jannovar.progress.GenomeRegion;

public final class GenomeRegionList {
    ImmutableList<GenomeRegion> genomeRegions;
    ImmutableMap<String, GenomeRegion> nameToRegion;

    public GenomeRegionList(Iterable<GenomeRegion> regions) {
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        for (GenomeRegion region : regions) {
            listBuilder.add((Object)region);
            mapBuilder.put((Object)region.getContig(), (Object)region);
        }
        this.genomeRegions = listBuilder.build();
        this.nameToRegion = mapBuilder.build();
    }

    public long lengthUpTo(String contig, int pos) {
        if (this.getGenomeRegion(contig) == null) {
            throw new IllegalArgumentException("Contig " + contig + " not found");
        }
        long result = 0L;
        for (GenomeRegion region : this.genomeRegions) {
            if (region.getContig().equals(contig)) {
                result += (long)pos;
                break;
            }
            result += (long)region.length();
        }
        return result;
    }

    public long totalLength() {
        return this.genomeRegions.stream().mapToLong(r -> r.length()).sum();
    }

    public GenomeRegion getGenomeRegion(String name) {
        return (GenomeRegion)this.nameToRegion.getOrDefault((Object)name, null);
    }

    public ImmutableList<GenomeRegion> getGenomeRegions() {
        return this.genomeRegions;
    }

    public void setGenomeRegions(ImmutableList<GenomeRegion> genomeRegions) {
        this.genomeRegions = genomeRegions;
    }

    public ImmutableMap<String, GenomeRegion> getNameToRegion() {
        return this.nameToRegion;
    }

    public void setNameToRegion(ImmutableMap<String, GenomeRegion> nameToRegion) {
        this.nameToRegion = nameToRegion;
    }

    public String toString() {
        return "GenomeRegionList [genomeRegions=" + this.genomeRegions + ", nameToRegion=" + this.nameToRegion + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.genomeRegions == null ? 0 : this.genomeRegions.hashCode());
        result = 31 * result + (this.nameToRegion == null ? 0 : this.nameToRegion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenomeRegionList other = (GenomeRegionList)obj;
        if (this.genomeRegions == null ? other.genomeRegions != null : !this.genomeRegions.equals(other.genomeRegions)) {
            return false;
        }
        return !(this.nameToRegion == null ? other.nameToRegion != null : !this.nameToRegion.equals(other.nameToRegion));
    }
}

