/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.progress;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import de.charite.compbio.jannovar.progress.GenomeRegion;
import de.charite.compbio.jannovar.progress.GenomeRegionList;
import htsjdk.variant.variantcontext.VariantContext;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;

public class ProgressReporter
extends TimerTask {
    private static ImmutableList<String> HEADERS = ImmutableList.of((Object)"Location", (Object)"processed.sites", (Object)"runtime.per.1M.sites", (Object)"completed", (Object)"total.runtime", (Object)"remaining");
    private final GenomeRegionList contigs;
    private VariantContext currentVC;
    private int numProcessed;
    private int seconds;
    private long startTime;

    public ProgressReporter(GenomeRegionList contigs, int seconds) {
        this.contigs = contigs;
        this.currentVC = null;
        this.numProcessed = 0;
        this.seconds = seconds;
        this.startTime = System.currentTimeMillis();
    }

    public void printHeader() {
        System.err.println(Joiner.on((String)"\t").join(HEADERS));
    }

    public void print() {
        VariantContext vc = this.currentVC;
        if (vc == null) {
            return;
        }
        long elapsed = (System.currentTimeMillis() - this.startTime) / 1000L;
        double timeFor1MSites = (double)elapsed / ((double)this.numProcessed / 1000.0 / 1000.0);
        long basesDone = this.contigs.lengthUpTo(vc.getContig(), vc.getStart() - 1);
        long basesTotal = this.contigs.totalLength();
        double percentDone = 100.0 * (double)basesDone / (double)basesTotal;
        long estimateTotal = (long)((double)elapsed / (percentDone / 100.0));
        long estimateRemaining = estimateTotal - elapsed;
        ArrayList<String> arr = new ArrayList<String>();
        arr.add(vc.getContig() + ":" + NumberFormat.getNumberInstance(Locale.US).format(vc.getStart()));
        arr.add(Integer.toString(this.numProcessed));
        arr.add(String.format("%.1f", timeFor1MSites));
        arr.add(String.format("%.1f%%", percentDone));
        arr.add(this.formatDuration(estimateTotal));
        arr.add(this.formatDuration(estimateRemaining));
        System.err.println(Joiner.on((String)"\t").join(arr));
    }

    public String formatDuration(long seconds) {
        if ((double)seconds > 129600.0) {
            return String.format("%.1f d", (double)seconds / 60.0 / 60.0 / 24.0);
        }
        if ((double)seconds > 5400.0) {
            return String.format("%.1f h", (double)seconds / 60.0 / 60.0);
        }
        if ((double)seconds > 90.0) {
            return String.format("%.1f min", (double)seconds / 60.0);
        }
        return String.format("%d s", seconds);
    }

    @Override
    public void run() {
        this.print();
    }

    public void start() {
        Timer timer = new Timer(true);
        timer.schedule((TimerTask)this, 0L, (long)(this.seconds * 1000));
    }

    public synchronized VariantContext getCurrentVC() {
        return this.currentVC;
    }

    public synchronized void setCurrentVC(VariantContext currentVC) {
        ++this.numProcessed;
        this.currentVC = currentVC;
    }

    public int getNumProcessed() {
        return this.numProcessed;
    }

    public void done() {
        long basesTotal;
        long elapsed = System.currentTimeMillis() - this.startTime;
        double timeFor1MSites = (double)elapsed / 1000.0 / ((double)this.numProcessed / 1000.0 / 1000.0);
        long basesDone = basesTotal = this.contigs.totalLength();
        double percentDone = 100.0 * (double)basesDone / (double)basesTotal;
        long estimateTotal = (long)((double)elapsed / (percentDone / 100.0));
        long estimateRemaining = estimateTotal - elapsed;
        GenomeRegion last = (GenomeRegion)this.contigs.getGenomeRegions().get(this.contigs.getGenomeRegions().size() - 1);
        ArrayList<String> arr = new ArrayList<String>();
        arr.add(last.getContig() + ":" + (last.getBeginPos() + 1));
        arr.add(Integer.toString(this.numProcessed));
        arr.add(String.format("%.1f", timeFor1MSites));
        arr.add(String.format("%.1f%%", percentDone));
        arr.add(this.formatDuration(estimateTotal));
        arr.add(this.formatDuration(estimateRemaining));
        System.err.println(Joiner.on((String)"\t").join(arr));
    }
}

