/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.bridge;

import de.charite.compbio.jannovar.annotation.InvalidGenomeVariant;
import de.charite.compbio.jannovar.hgvs.SequenceType;
import de.charite.compbio.jannovar.hgvs.bridge.CannotTranslateHGVSVariant;
import de.charite.compbio.jannovar.hgvs.bridge.NucleotideChangeToGenomeVariantTranslationImplBase;
import de.charite.compbio.jannovar.hgvs.bridge.ResultWithWarnings;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideRange;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideSeqDescription;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideDuplication;
import de.charite.compbio.jannovar.htsjdk.GenomeRegionSequenceExtractor;
import de.charite.compbio.jannovar.reference.GenomeInterval;
import de.charite.compbio.jannovar.reference.GenomeVariant;
import de.charite.compbio.jannovar.reference.Strand;
import de.charite.compbio.jannovar.reference.TranscriptModel;

class NucleotideDuplicationToGenomeVariantTranslationImpl
extends NucleotideChangeToGenomeVariantTranslationImplBase {
    public NucleotideDuplicationToGenomeVariantTranslationImpl(GenomeRegionSequenceExtractor seqExtractor) {
        super(seqExtractor);
    }

    public ResultWithWarnings<GenomeVariant> run(TranscriptModel tm, SequenceType sequenceType, NucleotideDuplication ntDup) throws CannotTranslateHGVSVariant, InvalidGenomeVariant {
        NucleotideRange range = ntDup.getRange();
        NucleotideSeqDescription duplicatedNTDesc = ntDup.getSeq();
        GenomeInterval gItv = this.posConverter.translateNucleotideRange(tm, range, sequenceType);
        String warningMsg = null;
        String duplicatedNTs = duplicatedNTDesc.getNucleotides();
        if (duplicatedNTs == null) {
            duplicatedNTs = this.getGenomeSeq(tm.getStrand(), gItv);
            if (duplicatedNTDesc.length() != -1 && duplicatedNTDesc.length() != duplicatedNTs.length()) {
                warningMsg = "Invalid nucleotide count in " + ntDup.toHGVSString() + ", expected " + duplicatedNTs.length();
            }
        } else {
            String refSeq = this.getGenomeSeq(tm.getStrand(), gItv);
            if (!refSeq.equals(duplicatedNTs)) {
                warningMsg = "Invalid nucleotides in " + ntDup.toHGVSString() + ", expected " + refSeq;
            }
            duplicatedNTs = refSeq;
        }
        GenomeVariant result = new GenomeVariant(gItv.withStrand(tm.getStrand()).getGenomeEndPos(), "", duplicatedNTs, tm.getStrand()).withStrand(Strand.FWD);
        if (warningMsg != null) {
            return ResultWithWarnings.construct(result, warningMsg);
        }
        return ResultWithWarnings.construct(result);
    }
}

