/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.bridge;

import de.charite.compbio.jannovar.annotation.InvalidGenomeVariant;
import de.charite.compbio.jannovar.hgvs.SequenceType;
import de.charite.compbio.jannovar.hgvs.bridge.CannotTranslateHGVSVariant;
import de.charite.compbio.jannovar.hgvs.bridge.NucleotideChangeToGenomeVariantTranslationImplBase;
import de.charite.compbio.jannovar.hgvs.bridge.ResultWithWarnings;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideRange;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideSeqDescription;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideInversion;
import de.charite.compbio.jannovar.htsjdk.GenomeRegionSequenceExtractor;
import de.charite.compbio.jannovar.impl.util.DNAUtils;
import de.charite.compbio.jannovar.reference.GenomeInterval;
import de.charite.compbio.jannovar.reference.GenomeVariant;
import de.charite.compbio.jannovar.reference.Strand;
import de.charite.compbio.jannovar.reference.TranscriptModel;

class NucleotideInversionToGenomeVariantTranslationImpl
extends NucleotideChangeToGenomeVariantTranslationImplBase {
    public NucleotideInversionToGenomeVariantTranslationImpl(GenomeRegionSequenceExtractor seqExtractor) {
        super(seqExtractor);
    }

    public ResultWithWarnings<GenomeVariant> run(TranscriptModel tm, SequenceType sequenceType, NucleotideInversion ntInv) throws CannotTranslateHGVSVariant, InvalidGenomeVariant {
        NucleotideRange range = ntInv.getRange();
        NucleotideSeqDescription invertedNTDesc = ntInv.getSeq();
        GenomeInterval gItv = this.posConverter.translateNucleotideRange(tm, range, sequenceType);
        String warningMsg = null;
        String invertedNTs = invertedNTDesc.getNucleotides();
        if (invertedNTs == null) {
            invertedNTs = this.getGenomeSeq(tm.getStrand(), gItv);
            if (invertedNTDesc.length() != -1 && invertedNTDesc.length() != invertedNTs.length()) {
                warningMsg = "Invalid nucleotide count in " + ntInv.toHGVSString() + ", expected " + invertedNTs.length();
            }
        } else {
            String refSeq = this.getGenomeSeq(tm.getStrand(), gItv);
            if (!refSeq.equals(invertedNTs)) {
                warningMsg = "Invalid nucleotides in " + ntInv.toHGVSString() + ", expected " + refSeq;
            }
            invertedNTs = refSeq;
        }
        GenomeVariant result = new GenomeVariant(gItv.withStrand(tm.getStrand()).getGenomeBeginPos(), invertedNTs, DNAUtils.reverseComplement((String)invertedNTs), tm.getStrand()).withStrand(Strand.FWD);
        if (warningMsg != null) {
            return ResultWithWarnings.construct(result, warningMsg);
        }
        return ResultWithWarnings.construct(result);
    }
}

