/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.bridge;

import de.charite.compbio.jannovar.hgvs.SequenceType;
import de.charite.compbio.jannovar.hgvs.bridge.CannotTranslateHGVSVariant;
import de.charite.compbio.jannovar.hgvs.nts.NucleotidePointLocation;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideRange;
import de.charite.compbio.jannovar.reference.CDSPosition;
import de.charite.compbio.jannovar.reference.GenomeInterval;
import de.charite.compbio.jannovar.reference.GenomePosition;
import de.charite.compbio.jannovar.reference.ProjectionException;
import de.charite.compbio.jannovar.reference.TranscriptModel;
import de.charite.compbio.jannovar.reference.TranscriptPosition;
import de.charite.compbio.jannovar.reference.TranscriptProjectionDecorator;

public class NucleotideLocationConverter {
    public GenomePosition translateNucleotidePointLocation(TranscriptModel tm, NucleotidePointLocation pos, SequenceType sequenceType) throws CannotTranslateHGVSVariant {
        switch (sequenceType) {
            case CODING_DNA: {
                return this.translateCodingNucleotidePointLocation(tm, pos);
            }
            case NON_CODING_DNA: {
                return this.translateNonCodingNucleotidePointLocation(tm, pos);
            }
        }
        throw new CannotTranslateHGVSVariant("Unsupported sequence type " + sequenceType);
    }

    protected GenomePosition translateCodingNucleotidePointLocation(TranscriptModel tm, NucleotidePointLocation pos) throws CannotTranslateHGVSVariant {
        TranscriptPosition txPos;
        TranscriptProjectionDecorator projector = new TranscriptProjectionDecorator(tm);
        if (pos.getBasePos() < 0) {
            txPos = projector.cdsToTranscriptPos(new CDSPosition(tm, 0));
            if (txPos.getPos() < -pos.getBasePos()) {
                throw new CannotTranslateHGVSVariant("Invalid CDS position " + pos.toHGVSString() + " as it lies upstream of 5' UTR");
            }
            txPos = new TranscriptPosition(tm, txPos.getPos() + pos.getBasePos());
        } else if (pos.isDownstreamOfCDS()) {
            CDSPosition lastCDSPos = new CDSPosition(tm, tm.cdsTranscriptLength() - 1);
            txPos = projector.cdsToTranscriptPos(lastCDSPos);
            int SHIFT = -3;
            if ((txPos = txPos.shifted(pos.getBasePos() + 1 + -3)).getPos() >= tm.transcriptLength()) {
                throw new CannotTranslateHGVSVariant("Invalid CDS position " + pos.toHGVSString() + " as it lies downstream of 3' UTR");
            }
        } else {
            CDSPosition cdsPos = new CDSPosition(tm, pos.getBasePos());
            txPos = projector.cdsToTranscriptPos(cdsPos);
        }
        try {
            return projector.transcriptToGenomePos(txPos).withStrand(tm.getStrand()).shifted(pos.getOffset());
        }
        catch (ProjectionException e) {
            throw new CannotTranslateHGVSVariant("could not translate base transcript position " + txPos + " of " + pos.toHGVSString() + " to a genome position", e);
        }
    }

    protected GenomePosition translateNonCodingNucleotidePointLocation(TranscriptModel tm, NucleotidePointLocation pos) throws CannotTranslateHGVSVariant {
        TranscriptProjectionDecorator projector = new TranscriptProjectionDecorator(tm);
        TranscriptPosition txPos = new TranscriptPosition(tm, pos.getBasePos());
        try {
            return projector.transcriptToGenomePos(txPos).withStrand(tm.getStrand()).shifted(pos.getOffset());
        }
        catch (ProjectionException e) {
            throw new CannotTranslateHGVSVariant("could not translate base transcript position " + txPos + " of " + pos.toHGVSString() + " to a genome position", e);
        }
    }

    public GenomeInterval translateNucleotideRange(TranscriptModel tm, NucleotideRange range, SequenceType sequenceType) throws CannotTranslateHGVSVariant {
        GenomePosition firstPos = this.translateNucleotidePointLocation(tm, range.getFirstPos(), sequenceType);
        GenomePosition lastPos = this.translateNucleotidePointLocation(tm, range.getLastPos(), sequenceType);
        int length = lastPos.differenceTo(firstPos) + 1;
        return new GenomeInterval(firstPos, length);
    }
}

