/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.htsjdk;

import de.charite.compbio.jannovar.UncheckedJannovarException;
import de.charite.compbio.jannovar.data.JannovarData;
import de.charite.compbio.jannovar.reference.GenomeInterval;
import de.charite.compbio.jannovar.reference.Strand;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.IndexedFastaSequenceFile;
import htsjdk.samtools.reference.ReferenceSequence;

public class GenomeRegionSequenceExtractor {
    final JannovarData jannovarData;
    IndexedFastaSequenceFile indexedFile;

    public GenomeRegionSequenceExtractor(JannovarData jannovarData, IndexedFastaSequenceFile indexedFile) {
        this.jannovarData = jannovarData;
        this.indexedFile = indexedFile;
        if (this.indexedFile.getSequenceDictionary() == null) {
            throw new UncheckedJannovarException("FASTA file has no sequence dictionary. Are you missing the REFERENCE.dict file? Hint: create with samtools dict (version >=1.2) or Picard.");
        }
    }

    public String load(GenomeInterval region) {
        region = region.withStrand(Strand.FWD);
        String contigName = (String)region.getRefDict().getContigIDToName().get((Object)region.getChr());
        contigName = this.mapContigToFasta(contigName);
        ReferenceSequence seq = this.indexedFile.getSubsequenceAt(contigName, (long)(region.getBeginPos() + 1), (long)region.getEndPos());
        return new String(seq.getBases());
    }

    private String mapContigToFasta(String contigName) {
        Integer contigID = (Integer)this.jannovarData.getRefDict().getContigNameToID().get((Object)contigName);
        if (contigID == null) {
            throw new UncheckedJannovarException("Unknown contig name " + contigName);
        }
        String nameInFasta = null;
        for (SAMSequenceRecord record : this.indexedFile.getSequenceDictionary().getSequences()) {
            if (!this.jannovarData.getRefDict().getContigNameToID().containsKey((Object)record.getSequenceName())) continue;
            String contigInFasta = record.getSequenceName();
            if (this.jannovarData.getRefDict().getContigNameToID().get((Object)contigInFasta) != contigID) continue;
            nameInFasta = contigInFasta;
            break;
        }
        if (nameInFasta == null) {
            throw new UncheckedJannovarException("Could not find corresponding contig in FASTA for " + contigName);
        }
        return nameInFasta;
    }
}

