/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.htsjdk;

import com.google.common.collect.ImmutableList;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;

public final class VariantContextWriterConstructionHelper {
    public static VariantContextWriter openVariantContextWriter(VCFHeader header, OutputStream outStream, Collection<VCFHeaderLine> additionalHeaderLines) {
        VariantContextWriterBuilder builder = VariantContextWriterConstructionHelper.makeBuilder(header);
        builder.unsetOption(Options.INDEX_ON_THE_FLY);
        builder.setOutputStream(outStream);
        VariantContextWriter out = builder.build();
        VCFHeader updatedHeader = VariantContextWriterConstructionHelper.extendHeaderFields(new VCFHeader(header));
        for (VCFHeaderLine headerLine : additionalHeaderLines) {
            updatedHeader.addMetaDataLine(headerLine);
        }
        out.writeHeader(updatedHeader);
        return out;
    }

    public static VariantContextWriter openVariantContextWriter(VCFHeader header, String fileName, Collection<VCFHeaderLine> additionalHeaderLines) {
        return VariantContextWriterConstructionHelper.openVariantContextWriter(header, fileName, additionalHeaderLines, false);
    }

    public static VariantContextWriter openVariantContextWriter(VCFHeader header, String fileName, Collection<VCFHeaderLine> additionalHeaderLines, boolean generateIndex) {
        VariantContextWriterBuilder builder = VariantContextWriterConstructionHelper.makeBuilder(header);
        builder.setOutputFile(new File(fileName));
        if (!generateIndex) {
            builder.unsetOption(Options.INDEX_ON_THE_FLY);
        }
        VariantContextWriter out = builder.build();
        VCFHeader updatedHeader = VariantContextWriterConstructionHelper.extendHeaderFields(new VCFHeader(header));
        for (VCFHeaderLine headerLine : additionalHeaderLines) {
            updatedHeader.addMetaDataLine(headerLine);
        }
        out.writeHeader(updatedHeader);
        return out;
    }

    private static VariantContextWriterBuilder makeBuilder(VCFHeader header) {
        VariantContextWriterBuilder builder = new VariantContextWriterBuilder();
        builder.setReferenceDictionary(header.getSequenceDictionary());
        builder.setOption(Options.ALLOW_MISSING_FIELDS_IN_HEADER);
        if (header.getSequenceDictionary() == null) {
            builder.unsetOption(Options.INDEX_ON_THE_FLY);
        }
        return builder;
    }

    public static VariantContextWriter openVariantContextWriter(VCFHeader header, String fileName) {
        return VariantContextWriterConstructionHelper.openVariantContextWriter(header, fileName, (Collection<VCFHeaderLine>)ImmutableList.of());
    }

    public static VCFHeader extendHeaderFields(VCFHeader header) {
        VCFInfoHeaderLine annLine = new VCFInfoHeaderLine("ANN", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Functional annotations:'Allele|Annotation|Annotation_Impact|Gene_Name|Gene_ID|Feature_Type|Feature_ID|Transcript_BioType|Rank|HGVS.c|HGVS.p|cDNA.pos / cDNA.length|CDS.pos / CDS.length|AA.pos / AA.length|Distance|ERRORS / WARNINGS / INFO'");
        header.addMetaDataLine((VCFHeaderLine)annLine);
        VCFInfoHeaderLine svAnnLine = new VCFInfoHeaderLine("SVANN", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Functional SV Annotation:'Annotation|Annotation_Impact|Gene_Name|Gene_ID|Feature_Type|Feature_ID|Transcript_BioType|ERRORS / WARNINGS / INFO'");
        header.addMetaDataLine((VCFHeaderLine)svAnnLine);
        return header;
    }
}

