/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.mendel.filter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.charite.compbio.jannovar.impl.intervals.IntervalArray;
import de.charite.compbio.jannovar.impl.intervals.IntervalEndExtractor;
import de.charite.compbio.jannovar.mendel.filter.Gene;
import de.charite.compbio.jannovar.mendel.filter.GeneIntervalEndExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class GeneList {
    private final ImmutableList<Gene> genes;
    private final ImmutableMap<Integer, IntervalArray<Gene>> gIntervalTree;

    public GeneList(ImmutableList<Gene> genes) {
        this.genes = genes;
        this.gIntervalTree = this.buildIntervalTree();
    }

    public ImmutableList<Gene> getGenes() {
        return this.genes;
    }

    public ImmutableMap<Integer, IntervalArray<Gene>> getGeneIntervalTree() {
        return this.gIntervalTree;
    }

    private ImmutableMap<Integer, IntervalArray<Gene>> buildIntervalTree() {
        HashMap chrToGene = new HashMap();
        for (Gene gene : this.genes) {
            if (!chrToGene.containsKey(gene.getRegion().getChr())) {
                chrToGene.put(gene.getRegion().getChr(), new ArrayList());
            }
            ((ArrayList)chrToGene.get(gene.getRegion().getChr())).add(gene);
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry entry : chrToGene.entrySet()) {
            builder.put((Object)((Integer)entry.getKey()), (Object)new IntervalArray((Collection)entry.getValue(), (IntervalEndExtractor)new GeneIntervalEndExtractor()));
        }
        return builder.build();
    }
}

