/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.bridge;

import de.charite.compbio.jannovar.annotation.InvalidGenomeVariant;
import de.charite.compbio.jannovar.hgvs.SequenceType;
import de.charite.compbio.jannovar.hgvs.bridge.CannotTranslateHGVSVariant;
import de.charite.compbio.jannovar.hgvs.bridge.NucleotideChangeToGenomeVariantTranslationImplBase;
import de.charite.compbio.jannovar.hgvs.bridge.ResultWithWarnings;
import de.charite.compbio.jannovar.hgvs.nts.NucleotidePointLocation;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideSubstitution;
import de.charite.compbio.jannovar.htsjdk.GenomeRegionSequenceExtractor;
import de.charite.compbio.jannovar.reference.GenomeVariant;
import de.charite.compbio.jannovar.reference.Strand;
import de.charite.compbio.jannovar.reference.TranscriptModel;

class NucleotideSubstitutionToGenomeVariantTranslationImpl
extends NucleotideChangeToGenomeVariantTranslationImplBase {
    public NucleotideSubstitutionToGenomeVariantTranslationImpl(GenomeRegionSequenceExtractor seqExtractor) {
        super(seqExtractor);
    }

    public ResultWithWarnings<GenomeVariant> run(TranscriptModel tm, SequenceType sequenceType, NucleotideSubstitution ntSub) throws CannotTranslateHGVSVariant, InvalidGenomeVariant {
        NucleotidePointLocation pos = ntSub.getPosition();
        String fromNT = ntSub.getFromNT().toUpperCase();
        String toNT = ntSub.getToNT().toUpperCase();
        if (fromNT.length() != 1 || toNT.length() != 1) {
            throw new CannotTranslateHGVSVariant("Both source and target sequence must have length 1 in " + ntSub.toHGVSString());
        }
        GenomeVariant result = new GenomeVariant(this.posConverter.translateNucleotidePointLocation(tm, pos, sequenceType), fromNT, toNT, tm.getStrand()).withStrand(Strand.FWD);
        String refSeq = this.getGenomeSeq(tm.getStrand(), result.getGenomeInterval());
        if (!refSeq.equals(fromNT)) {
            GenomeVariant result2 = new GenomeVariant(this.posConverter.translateNucleotidePointLocation(tm, pos, sequenceType), refSeq, toNT, tm.getStrand()).withStrand(Strand.FWD);
            return ResultWithWarnings.construct(result2, "Invalid reference nucleotides in " + result.toString() + ", should be " + refSeq + ", auto-correcting.");
        }
        return ResultWithWarnings.construct(result);
    }
}

