/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.htsjdk;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.charite.compbio.jannovar.annotation.Annotation;
import de.charite.compbio.jannovar.annotation.AnnotationMessage;
import de.charite.compbio.jannovar.annotation.SVAnnotation;
import de.charite.compbio.jannovar.annotation.SVAnnotations;
import de.charite.compbio.jannovar.annotation.SVAnnotator;
import de.charite.compbio.jannovar.annotation.VariantAnnotations;
import de.charite.compbio.jannovar.annotation.VariantAnnotator;
import de.charite.compbio.jannovar.annotation.builders.AnnotationBuilderOptions;
import de.charite.compbio.jannovar.data.Chromosome;
import de.charite.compbio.jannovar.data.ReferenceDictionary;
import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.htsjdk.InvalidBreakendDescriptionException;
import de.charite.compbio.jannovar.htsjdk.InvalidCoordinatesException;
import de.charite.compbio.jannovar.htsjdk.MissingEndInfoField;
import de.charite.compbio.jannovar.htsjdk.MissingSVTypeInfoField;
import de.charite.compbio.jannovar.htsjdk.MixingSmallAndSVAlleles;
import de.charite.compbio.jannovar.htsjdk.MultipleSVAlleles;
import de.charite.compbio.jannovar.htsjdk.VariantEffectHeaderExtender;
import de.charite.compbio.jannovar.reference.GenomePosition;
import de.charite.compbio.jannovar.reference.GenomeVariant;
import de.charite.compbio.jannovar.reference.PositionType;
import de.charite.compbio.jannovar.reference.SVBreakend;
import de.charite.compbio.jannovar.reference.SVCopyNumberVariant;
import de.charite.compbio.jannovar.reference.SVDeletion;
import de.charite.compbio.jannovar.reference.SVDuplication;
import de.charite.compbio.jannovar.reference.SVGenomeVariant;
import de.charite.compbio.jannovar.reference.SVInsertion;
import de.charite.compbio.jannovar.reference.SVInversion;
import de.charite.compbio.jannovar.reference.SVMobileElementDeletion;
import de.charite.compbio.jannovar.reference.SVMobileElementInsertion;
import de.charite.compbio.jannovar.reference.SVTandemDuplication;
import de.charite.compbio.jannovar.reference.SVUnknown;
import de.charite.compbio.jannovar.reference.Strand;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VariantContextAnnotator {
    private static final Pattern BND_PATTERN = Pattern.compile("^(?<leadingBases>\\w*)(?<firstBracket>[\\[\\]])(?<targetChrom>[^:]+):(?<targetPos>\\w+)(?<secondBracket>[\\[\\]])(?<trailingBases>\\w*)$");
    private static final Logger LOGGER = LoggerFactory.getLogger(VariantContextAnnotator.class);
    private final ReferenceDictionary refDict;
    private final ImmutableMap<Integer, Chromosome> chromosomeMap;
    private final Options options;
    private final VariantAnnotator annotator;
    private final SVAnnotator svAnnotator;

    public VariantContextAnnotator(ReferenceDictionary refDict, ImmutableMap<Integer, Chromosome> chromosomeMap) {
        this(refDict, chromosomeMap, new Options());
    }

    public VariantContextAnnotator(ReferenceDictionary refDict, ImmutableMap<Integer, Chromosome> chromosomeMap, Options options) {
        this.refDict = refDict;
        this.chromosomeMap = chromosomeMap;
        this.options = options;
        this.annotator = new VariantAnnotator(refDict, chromosomeMap, new AnnotationBuilderOptions(options.nt3PrimeShifting, false));
        this.svAnnotator = new SVAnnotator(refDict, chromosomeMap);
    }

    public ReferenceDictionary getRefDict() {
        return this.refDict;
    }

    public ImmutableMap<Integer, Chromosome> getChromosomeMap() {
        return this.chromosomeMap;
    }

    public Options getOptions() {
        return this.options;
    }

    public VariantAnnotator getAnnotator() {
        return this.annotator;
    }

    public GenomeVariant buildGenomeVariant(VariantContext vc, int alleleID) throws InvalidCoordinatesException {
        Integer boxedInt = (Integer)this.refDict.getContigNameToID().get((Object)vc.getContig());
        if (boxedInt == null) {
            throw new InvalidCoordinatesException("Unknown reference " + vc.getContig(), AnnotationMessage.ERROR_CHROMOSOME_NOT_FOUND);
        }
        int chr = boxedInt;
        String ref = vc.getReference().getBaseString();
        Allele altAllele = vc.getAlternateAllele(alleleID);
        String alt = altAllele.getBaseString();
        int pos = vc.getStart();
        return new GenomeVariant(new GenomePosition(this.refDict, Strand.FWD, chr, pos, PositionType.ONE_BASED), ref, alt);
    }

    public void putErrorAnnotation(VariantContext vc, Set<AnnotationMessage> messages) {
        String annotation = "|||||||||||||||" + Joiner.on((char)'&').join(messages);
        HashMap<String, String> attributes = new HashMap<String, String>(vc.getAttributes());
        attributes.put("ANN", annotation);
        vc.getCommonInfo().setAttributes(attributes);
    }

    public VariantContext annotateVariantContext(VariantContext vc) {
        try {
            vc = this.dispatchAnnotateVariantContext(vc);
        }
        catch (InvalidCoordinatesException e) {
            this.putErrorAnnotation(vc, (Set<AnnotationMessage>)ImmutableSet.of((Object)e.getAnnotationMessage()));
        }
        catch (MixingSmallAndSVAlleles e) {
            LOGGER.error("Cannot mix small and structural variant in {}", new Object[]{e});
            this.putErrorAnnotation(vc, (Set<AnnotationMessage>)ImmutableSet.of((Object)AnnotationMessage.ERROR_PROBLEM_DURING_ANNOTATION));
        }
        catch (InvalidBreakendDescriptionException | MissingEndInfoField | MissingSVTypeInfoField | MultipleSVAlleles e) {
            LOGGER.error("Problem annotating SV in {}", new Object[]{e});
            this.putErrorAnnotation(vc, (Set<AnnotationMessage>)ImmutableSet.of((Object)AnnotationMessage.OTHER_MESSAGE));
        }
        vc.getCommonInfo().removeAttribute("");
        return vc;
    }

    public VariantContext dispatchAnnotateVariantContext(VariantContext vc) throws MixingSmallAndSVAlleles, InvalidCoordinatesException, MissingSVTypeInfoField, MissingEndInfoField, MultipleSVAlleles, InvalidBreakendDescriptionException {
        Boolean isSymbolic = null;
        for (Allele allele : vc.getAlternateAlleles()) {
            boolean symbolic = GenomeVariant.wouldBeSymbolicAllele((String)allele.getBaseString());
            if (isSymbolic == null) {
                isSymbolic = symbolic;
                continue;
            }
            if (isSymbolic == symbolic) continue;
            throw new MixingSmallAndSVAlleles("Mixing small and structural variant");
        }
        boolean hasSVType = vc.getCommonInfo().hasAttribute("SVTYPE");
        if (isSymbolic == null) {
            return vc;
        }
        if (!isSymbolic.booleanValue() && !hasSVType) {
            return this.applyAnnotations(vc, (List<VariantAnnotations>)this.buildAnnotations(vc));
        }
        return this.applySVAnnotations(vc, (List<SVAnnotations>)this.buildSVAnnotations(vc));
    }

    public ImmutableList<VariantAnnotations> buildAnnotations(VariantContext vc) throws InvalidCoordinatesException {
        LOGGER.trace("building annotation lists for {}", new Object[]{vc});
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int alleleID = 0; alleleID < vc.getAlternateAlleles().size(); ++alleleID) {
            GenomeVariant change = this.buildGenomeVariant(vc, alleleID);
            try {
                VariantAnnotations lst = this.annotator.buildAnnotations(change);
                builder.add((Object)lst);
                LOGGER.trace("adding annotation list {}", new Object[]{lst});
                continue;
            }
            catch (Exception e) {
                VariantAnnotations lst = this.buildErrorAnnotations(change);
                builder.add((Object)lst);
                LOGGER.trace("adding error annotation list {}", new Object[]{lst});
            }
        }
        return builder.build();
    }

    public VariantContext applyAnnotations(VariantContext vc, List<VariantAnnotations> annos) {
        boolean offTargetInAll = true;
        ArrayList<String> annotations = new ArrayList<String>();
        for (int alleleID = 0; alleleID < vc.getAlternateAlleles().size(); ++alleleID) {
            if (annos.get(alleleID).getAnnotations().isEmpty()) continue;
            for (Annotation ann : annos.get(alleleID).getAnnotations()) {
                boolean offTargetInThis = ann.getEffects().stream().allMatch(e -> e.isOffExome(this.options.offTargetFilterUtrIsOffTarget, this.options.offTargetFilterIntronicSpliceIsOffTarget));
                boolean bl = offTargetInAll = offTargetInAll && offTargetInThis;
                if (this.options.oneAnnotationOnly && !annotations.isEmpty()) continue;
                String alt = vc.getAlternateAllele(alleleID).getBaseString();
                annotations.add(ann.toVCFAnnoString(alt, this.options.escapeAnnField, this.options.aminoAcidCode));
            }
        }
        if (this.options.isOffTargetFilterEnabled() && offTargetInAll && !annotations.isEmpty()) {
            HashSet<String> filters = new HashSet<String>(vc.getFilters());
            filters.add(VariantEffectHeaderExtender.FILTER_EFFECT_OFF_EXOME);
            vc = new VariantContextBuilder(vc).filters(filters).make();
        }
        HashMap<String, String> attributes = new HashMap<String, String>(vc.getAttributes());
        if (!annotations.isEmpty()) {
            attributes.put("ANN", Joiner.on((char)',').join(annotations));
        }
        vc.getCommonInfo().setAttributes(attributes);
        return vc;
    }

    public VariantAnnotations buildErrorAnnotations(GenomeVariant change) {
        return new VariantAnnotations(change, (Collection)ImmutableList.of((Object)new Annotation((Collection)ImmutableList.of((Object)AnnotationMessage.ERROR_PROBLEM_DURING_ANNOTATION))));
    }

    public SVAnnotations buildSVErrorAnnotations(SVGenomeVariant change) {
        return new SVAnnotations(change, (Collection)ImmutableList.of((Object)new SVAnnotation((Collection)ImmutableList.of((Object)AnnotationMessage.ERROR_PROBLEM_DURING_ANNOTATION))));
    }

    public ImmutableList<SVAnnotations> buildSVAnnotations(VariantContext vc) throws MultipleSVAlleles, MissingSVTypeInfoField, MissingEndInfoField, InvalidCoordinatesException, InvalidBreakendDescriptionException {
        LOGGER.trace("building SV annotation lists for {}", new Object[]{vc});
        if (vc.getAlternateAlleles().size() > 1) {
            throw new MultipleSVAlleles("More than one SV allele in variant: " + vc.toString());
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        SVGenomeVariant change = this.buildSVGenomeVariant(vc);
        try {
            SVAnnotations lst = this.svAnnotator.buildAnnotations(change);
            builder.add((Object)lst);
            LOGGER.trace("adding SV annotation list {}", new Object[]{lst});
        }
        catch (Exception e) {
            SVAnnotations lst = this.buildSVErrorAnnotations(change);
            builder.add((Object)lst);
            LOGGER.trace("adding SV error annotation list {}", new Object[]{lst});
        }
        return builder.build();
    }

    public SVGenomeVariant buildSVGenomeVariant(VariantContext vc) throws MissingSVTypeInfoField, InvalidCoordinatesException, MissingEndInfoField, InvalidBreakendDescriptionException {
        List ciPos2;
        List ciPos;
        GenomePosition gPos2;
        String altSVType;
        String tmpSVType;
        try {
            String tmp = URLDecoder.decode(vc.getCommonInfo().getAttributeAsString("SVTYPE", "UTF-8"), "UTF-8");
            tmpSVType = tmp.split(":")[0];
        }
        catch (UnsupportedEncodingException e) {
            throw new MissingSVTypeInfoField("Could not decode INFO/SVTYPE from: " + vc);
        }
        if (tmpSVType == null) {
            throw new MissingSVTypeInfoField("INFO field SVTYPE not found for variant: " + vc);
        }
        String altStr = vc.getAlternateAllele(0).toString();
        String svType = altStr.startsWith("<") && altStr.endsWith(">") ? (altSVType = altStr.substring(1, altStr.length() - 1)) : tmpSVType;
        Integer boxedInt = (Integer)this.refDict.getContigNameToID().get((Object)vc.getContig());
        if (boxedInt == null) {
            throw new InvalidCoordinatesException("Unknown reference " + vc.getContig(), AnnotationMessage.ERROR_CHROMOSOME_NOT_FOUND);
        }
        int chr = boxedInt;
        int pos = vc.getStart();
        GenomePosition gPos = new GenomePosition(this.refDict, Strand.FWD, chr, pos, PositionType.ONE_BASED);
        if (vc.getCommonInfo().hasAttribute("END")) {
            String contig2 = vc.getCommonInfo().getAttributeAsString("CHR2", vc.getContig());
            Integer boxedInt2 = (Integer)this.refDict.getContigNameToID().get((Object)contig2);
            if (boxedInt2 == null) {
                throw new InvalidCoordinatesException("Unknown reference " + contig2, AnnotationMessage.ERROR_CHROMOSOME_NOT_FOUND);
            }
            int chr2 = boxedInt2;
            int pos2 = vc.getCommonInfo().getAttributeAsInt("END", -1);
            if (pos2 == -1) {
                throw new InvalidCoordinatesException(AnnotationMessage.ERROR_CHROMOSOME_NOT_FOUND);
            }
            gPos2 = new GenomePosition(this.refDict, Strand.FWD, chr2, pos2, PositionType.ZERO_BASED);
        } else {
            gPos2 = null;
        }
        int lowerCIPos = 0;
        int upperCIPos = 0;
        if (vc.getCommonInfo().hasAttribute("CIPOS") && (ciPos = vc.getCommonInfo().getAttributeAsIntList("CIPOS", Integer.valueOf(-1))) != null && ciPos.size() == 2) {
            lowerCIPos = (Integer)ciPos.get(0);
            upperCIPos = (Integer)ciPos.get(1);
        }
        int lowerCIPos2 = 0;
        int upperCIPos2 = 0;
        if (vc.getCommonInfo().hasAttribute("CIEND") && (ciPos2 = vc.getCommonInfo().getAttributeAsIntList("CIEND", Integer.valueOf(-1))) != null && ciPos2.size() == 2) {
            lowerCIPos2 = (Integer)ciPos2.get(0);
            upperCIPos2 = (Integer)ciPos2.get(1);
        }
        if (svType.startsWith("DEL:ME") || svType.startsWith("DEL:LINE") || svType.startsWith("DEL:SINE") || svType.startsWith("DEL:DNA:TcMar-Tigger") || svType.startsWith("DEL:LTR")) {
            if (gPos2 == null) {
                throw new MissingEndInfoField("Missing INFO/END field in " + vc.toString());
            }
            return new SVMobileElementDeletion(gPos, gPos2, lowerCIPos, upperCIPos, lowerCIPos2, upperCIPos2);
        }
        if (svType.startsWith("DEL")) {
            if (gPos2 == null) {
                throw new MissingEndInfoField("Missing INFO/END field in " + vc.toString());
            }
            return new SVDeletion(gPos, gPos2, lowerCIPos, upperCIPos, lowerCIPos2, upperCIPos2);
        }
        if (svType.startsWith("DUP:TANDEM")) {
            if (gPos2 == null) {
                throw new MissingEndInfoField("Missing INFO/END field in " + vc.toString());
            }
            return new SVTandemDuplication(gPos, gPos2, lowerCIPos, upperCIPos, lowerCIPos2, upperCIPos2);
        }
        if (svType.startsWith("DUP")) {
            if (gPos2 == null) {
                throw new MissingEndInfoField("Missing INFO/END field in " + vc.toString());
            }
            return new SVDuplication(gPos, gPos2, lowerCIPos, upperCIPos, lowerCIPos2, upperCIPos2);
        }
        if (svType.startsWith("INS:ME")) {
            return new SVMobileElementInsertion(gPos, lowerCIPos, upperCIPos);
        }
        if (svType.startsWith("INS")) {
            return new SVInsertion(gPos, lowerCIPos, upperCIPos);
        }
        if (svType.startsWith("INV")) {
            if (gPos2 == null) {
                throw new MissingEndInfoField("Missing INFO/END field in " + vc.toString());
            }
            return new SVInversion(gPos, gPos2, lowerCIPos, upperCIPos, lowerCIPos2, upperCIPos2);
        }
        if (svType.startsWith("CNV")) {
            if (gPos2 == null) {
                throw new MissingEndInfoField("Missing INFO/END field in " + vc.toString());
            }
            return new SVCopyNumberVariant(gPos, gPos2, lowerCIPos, upperCIPos, lowerCIPos2, upperCIPos2);
        }
        if (svType.startsWith("BND")) {
            String secondBracket;
            Matcher matcher = BND_PATTERN.matcher(altStr);
            if (!matcher.matches()) {
                throw new InvalidBreakendDescriptionException("Not a valid BND alternative allele: " + vc.toString());
            }
            String firstBracket = matcher.group("firstBracket");
            if (!firstBracket.equals(secondBracket = matcher.group("secondBracket"))) {
                throw new InvalidBreakendDescriptionException("Not a valid BND alternative allele: " + vc.toString());
            }
            int chr2 = (Integer)this.refDict.getContigNameToID().get((Object)matcher.group("targetChrom"));
            int pos2 = Integer.parseInt(matcher.group("targetPos"));
            GenomePosition gBNDPos2 = new GenomePosition(this.refDict, Strand.FWD, chr2, pos2, PositionType.ZERO_BASED);
            String leadingBases = matcher.group("leadingBases");
            String trailingBases = matcher.group("trailingBases");
            return new SVBreakend(gPos, gBNDPos2, lowerCIPos, upperCIPos, lowerCIPos2, upperCIPos2, leadingBases, trailingBases, "]".equals(firstBracket) ? SVBreakend.Side.LEFT_END : SVBreakend.Side.RIGHT_END);
        }
        return new SVUnknown(gPos, gPos2 == null ? gPos : gPos2, lowerCIPos, upperCIPos, lowerCIPos2, upperCIPos2);
    }

    public VariantContext applySVAnnotations(VariantContext vc, List<SVAnnotations> annos) {
        boolean offTargetInAll = true;
        if (vc.getAlternateAlleles().size() > 1) {
            throw new RuntimeException("Must not have more than one alternate allele for SVs. This should have been caught earlier, though");
        }
        if (vc.getAlternateAlleles().size() != annos.size()) {
            throw new IllegalArgumentException("alt allele count != annos.size()");
        }
        if (vc.getAlternateAlleles().size() == 0) {
            return vc;
        }
        ArrayList<String> annotations = new ArrayList<String>();
        Object iterAnnos = this.options.oneAnnotationOnly ? annos.get(0).getHighestImpactAnnotation().values() : annos.get(0).getAnnotations();
        for (SVAnnotation ann : iterAnnos) {
            boolean offTargetInThis = ann.getEffects().stream().allMatch(e -> e.isOffExome(this.options.offTargetFilterUtrIsOffTarget, this.options.offTargetFilterIntronicSpliceIsOffTarget));
            offTargetInAll = offTargetInAll && offTargetInThis;
            annotations.add(ann.toVCFSVAnnoString(this.options.escapeAnnField));
        }
        if (this.options.isOffTargetFilterEnabled() && offTargetInAll && !annotations.isEmpty()) {
            HashSet<String> filters = new HashSet<String>(vc.getFilters());
            filters.add(VariantEffectHeaderExtender.FILTER_EFFECT_OFF_EXOME);
            vc = new VariantContextBuilder(vc).filters(filters).make();
        }
        HashMap<String, String> attributes = new HashMap<String, String>(vc.getAttributes());
        if (!annotations.isEmpty()) {
            attributes.put("SVANN", Joiner.on((char)',').join(annotations));
        }
        vc.getCommonInfo().setAttributes(attributes);
        return vc;
    }

    public static class Options {
        private final boolean oneAnnotationOnly;
        private final AminoAcidCode aminoAcidCode;
        private final boolean escapeAnnField;
        private final boolean nt3PrimeShifting;
        private boolean offTargetFilterEnabled;
        private boolean offTargetFilterUtrIsOffTarget;
        private boolean offTargetFilterIntronicSpliceIsOffTarget;

        public Options() {
            this.oneAnnotationOnly = true;
            this.aminoAcidCode = AminoAcidCode.ONE_LETTER;
            this.escapeAnnField = true;
            this.nt3PrimeShifting = true;
            this.offTargetFilterEnabled = false;
            this.offTargetFilterUtrIsOffTarget = false;
            this.offTargetFilterIntronicSpliceIsOffTarget = false;
        }

        public Options(boolean oneAnnotationOnly, AminoAcidCode code, boolean escapeAnnField, boolean nt3PrimeShifting, boolean offTargetFilterEnabled, boolean offTargetFilterUtrIsOffTarget, boolean offTargetFilterIntronicSpliceIsOffTarget) {
            this.oneAnnotationOnly = oneAnnotationOnly;
            this.aminoAcidCode = code;
            this.escapeAnnField = escapeAnnField;
            this.nt3PrimeShifting = nt3PrimeShifting;
            this.offTargetFilterEnabled = offTargetFilterEnabled;
            this.offTargetFilterUtrIsOffTarget = offTargetFilterUtrIsOffTarget;
            this.offTargetFilterIntronicSpliceIsOffTarget = offTargetFilterIntronicSpliceIsOffTarget;
        }

        public boolean isOneAnnotationOnly() {
            return this.oneAnnotationOnly;
        }

        public boolean isEscapeAnnField() {
            return this.escapeAnnField;
        }

        public boolean isNt3PrimeShifting() {
            return this.nt3PrimeShifting;
        }

        public boolean isOffTargetFilterEnabled() {
            return this.offTargetFilterEnabled;
        }

        public boolean isOffTargetFilterUtrIsOffTarget() {
            return this.offTargetFilterUtrIsOffTarget;
        }

        public boolean isOffTargetFilterIntronicSpliceIsOffTarget() {
            return this.offTargetFilterIntronicSpliceIsOffTarget;
        }
    }
}

