/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.mendel.filter;

import com.google.common.collect.ImmutableList;
import de.charite.compbio.jannovar.data.ReferenceDictionary;
import de.charite.compbio.jannovar.mendel.filter.Gene;
import de.charite.compbio.jannovar.reference.GenomeInterval;
import de.charite.compbio.jannovar.reference.TranscriptModel;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GeneBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneBuilder.class);
    private final ReferenceDictionary refDict;
    private String name = null;
    private final ImmutableList.Builder<TranscriptModel> builder = new ImmutableList.Builder();
    private final ArrayList<TranscriptModel> tmpModels = new ArrayList();

    public GeneBuilder(ReferenceDictionary refDict, String name) {
        this.refDict = refDict;
        this.name = name;
    }

    public void addTranscriptModel(TranscriptModel tm) {
        if (this.tmpModels.isEmpty()) {
            LOGGER.trace("Adding first transcript {} to gene {}.", new Object[]{tm, this.name});
            this.builder.add((Object)tm);
            this.tmpModels.add(tm);
            return;
        }
        int MORE_PADDING = 10000;
        GenomeInterval tmRegion = tm.getTXRegion().withMorePadding(10000);
        for (TranscriptModel model : this.tmpModels) {
            if (!model.getTXRegion().overlapsWith(tmRegion)) continue;
            LOGGER.trace("Adding next transcript {} to gene {}.", new Object[]{tm, this.name});
            this.builder.add((Object)tm);
            this.tmpModels.add(tm);
            return;
        }
        LOGGER.trace("Transcript {} does not fit to previous transcripts of {}.", new Object[]{tm, this.name});
    }

    public Gene build() {
        Gene gene = new Gene(this.refDict, this.name, (ImmutableList<TranscriptModel>)this.builder.build());
        LOGGER.trace("Creating gene {} (lengt={})", new Object[]{gene, this.name});
        return gene;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

