/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.mendel.filter;

import de.charite.compbio.jannovar.mendel.SubModeOfInheritance;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.TreeSet;

public class VariantContextCounter {
    private VariantContext variantContext;
    private int counter;
    private TreeSet<SubModeOfInheritance> compatibleModes;

    public VariantContextCounter(VariantContext variantContext) {
        this(variantContext, 0);
    }

    public VariantContextCounter(VariantContext variantContext, int counter) {
        this.variantContext = variantContext;
        this.counter = counter;
        this.compatibleModes = new TreeSet();
    }

    public int increment() {
        return ++this.counter;
    }

    public int decrement() {
        --this.counter;
        if (this.counter < 0) {
            throw new RuntimeException("Negative counter " + this.counter);
        }
        return this.counter;
    }

    public VariantContext getVariantContext() {
        return this.variantContext;
    }

    public void setVariantContext(VariantContext variantContext) {
        this.variantContext = variantContext;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
        if (this.counter < 0) {
            throw new RuntimeException("Negative counter " + this.counter);
        }
    }

    public void addCompatibleMode(SubModeOfInheritance mode) {
        this.compatibleModes.add(mode);
    }

    public TreeSet<SubModeOfInheritance> getCompatibleModes() {
        return this.compatibleModes;
    }

    public void setCompatibleModes(TreeSet<SubModeOfInheritance> compatibleModes) {
        this.compatibleModes = compatibleModes;
    }

    public String toString() {
        return "VariantContextCounter [variantContext=" + this.variantContext + ", counter=" + this.counter + ", compatibleModes=" + this.compatibleModes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.compatibleModes == null ? 0 : this.compatibleModes.hashCode());
        result = 31 * result + this.counter;
        result = 31 * result + (this.variantContext == null ? 0 : this.variantContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariantContextCounter other = (VariantContextCounter)obj;
        if (this.compatibleModes == null ? other.compatibleModes != null : !this.compatibleModes.equals(other.compatibleModes)) {
            return false;
        }
        if (this.counter != other.counter) {
            return false;
        }
        return !(this.variantContext == null ? other.variantContext != null : !this.variantContext.equals(other.variantContext));
    }
}

