/*
 * Decompiled with CFR 0.152.
 */
package de.chkal.maven.gitlab.codequality;

import de.chkal.maven.gitlab.codequality.Finding;
import de.chkal.maven.gitlab.codequality.FindingProvider;
import de.chkal.maven.gitlab.codequality.Logger;
import de.chkal.maven.gitlab.codequality.ReportSerializer;
import de.chkal.maven.gitlab.codequality.checkstyle.CheckstyleFindingProvider;
import de.chkal.maven.gitlab.codequality.spotbugs.SpotbugsFindingProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(defaultValue="true")
    public boolean spotbugsEnabled;
    @Parameter(defaultValue="${project.build.directory}/spotbugsXml.xml")
    public File spotbugsInputFile;
    @Parameter(defaultValue="true")
    public boolean checkstyleEnabled;
    @Parameter(defaultValue="${project.build.directory}/checkstyle-result.xml")
    public File checkstyleInputFile;
    @Parameter(defaultValue="${project.build.directory}/gl-code-quality-report.json")
    public File outputFile;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoFailureException {
        Logger log = new Logger(this.getLog());
        File repositoryRoot = GenerateMojo.getRepositoryRootDir(this.project.getBasedir(), log);
        ArrayList<Finding> findings = new ArrayList<Finding>();
        findings.addAll(GenerateMojo.executeProvider(new SpotbugsFindingProvider(this.project, repositoryRoot, log), this.spotbugsEnabled, this.spotbugsInputFile, log));
        findings.addAll(GenerateMojo.executeProvider(new CheckstyleFindingProvider(repositoryRoot), this.checkstyleEnabled, this.checkstyleInputFile, log));
        if (findings.size() > 0) {
            try (FileOutputStream stream = new FileOutputStream(this.outputFile);){
                new ReportSerializer().write(findings, stream);
                log.info("GitLab code quality report for {} issue created: {}", findings.size(), this.outputFile);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static List<Finding> executeProvider(FindingProvider provider, boolean active, File file, Logger log) throws MojoFailureException {
        if (active) {
            if (file.canRead()) {
                List<Finding> list;
                FileInputStream stream = new FileInputStream(file);
                try {
                    List<Finding> findings = provider.getFindings(stream);
                    log.info("{} report with {} issues found: {}", provider.getName(), findings.size(), file);
                    list = findings;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new MojoFailureException("IO error", (Throwable)e);
                    }
                }
                ((InputStream)stream).close();
                return list;
            }
            log.info("{} report not found: {}", provider.getName(), file);
        } else {
            log.info("{} support disabled.", provider.getName());
        }
        return Collections.emptyList();
    }

    private static File getRepositoryRootDir(File initial, Logger log) {
        File current = initial;
        do {
            if (!new File(current, ".git").exists()) continue;
            log.debug("Detected git root directory: {}", current);
            return current;
        } while ((current = current.getParentFile()) != null);
        log.warn("Failed to locate git root directory. Paths will most likely be incorrect.", new Object[0]);
        return initial;
    }
}

