/*
 * Decompiled with CFR 0.152.
 */
package de.chkal.maven.gitlab.codequality.checkstyle;

import de.chkal.maven.gitlab.codequality.Finding;
import de.chkal.maven.gitlab.codequality.FindingProvider;
import de.chkal.maven.gitlab.codequality.checkstyle.CheckstyleType;
import de.chkal.maven.gitlab.codequality.checkstyle.ErrorType;
import de.chkal.maven.gitlab.codequality.checkstyle.FileType;
import jakarta.xml.bind.DatatypeConverter;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class CheckstyleFindingProvider
implements FindingProvider {
    private final File repositoryRoot;

    public CheckstyleFindingProvider(File repositoryRoot) {
        this.repositoryRoot = repositoryRoot;
    }

    @Override
    public String getName() {
        return "Checkstyle";
    }

    @Override
    public List<Finding> getFindings(InputStream stream) {
        try {
            XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
            XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(stream);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CheckstyleType.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement checkstyleType = unmarshaller.unmarshal(xmlStreamReader, CheckstyleType.class);
            return ((CheckstyleType)checkstyleType.getValue()).getFile().stream().flatMap(this::transformFileType).collect(Collectors.toList());
        }
        catch (JAXBException | XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    private Stream<Finding> transformFileType(FileType fileType) {
        return fileType.getError().stream().map(errorType -> this.transformErrorType(fileType, (ErrorType)errorType));
    }

    private Finding transformErrorType(FileType fileType, ErrorType errorType) {
        Finding finding = new Finding();
        finding.setDescription(String.format("%s: %s", this.getName(), errorType.getMessage()));
        finding.setFingerprint(this.createFingerprint(fileType, errorType));
        finding.setSeverity(this.getSeverity(errorType.getSeverity()));
        finding.setPath(this.getRepositoryRelativePath(fileType));
        finding.setLine(CheckstyleFindingProvider.getLineNumber(errorType));
        return finding;
    }

    private String getRepositoryRelativePath(FileType fileType) {
        Path absolutePath = Path.of(fileType.getName(), new String[0]);
        return this.repositoryRoot.toPath().relativize(absolutePath).toString();
    }

    private Finding.Severity getSeverity(String severity) {
        switch (severity) {
            case "error": {
                return Finding.Severity.MAJOR;
            }
            case "warning": {
                return Finding.Severity.MINOR;
            }
        }
        return Finding.Severity.INFO;
    }

    private String createFingerprint(FileType fileType, ErrorType errorType) {
        try {
            String key = String.format("%s:%s:%s:%s", this.getRepositoryRelativePath(fileType), errorType.getSeverity(), errorType.getMessage(), errorType.getColumn());
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(key.getBytes(StandardCharsets.UTF_8));
            byte[] digest = messageDigest.digest();
            return DatatypeConverter.printHexBinary((byte[])digest).toLowerCase(Locale.ROOT);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static Integer getLineNumber(ErrorType errorType) {
        return errorType.getLine() != null && errorType.getLine().matches("\\d+") ? Integer.parseInt(errorType.getLine()) : 1;
    }
}

